package ru.yandex.passport.address;

import java.util.Objects;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeocoderRequest<T> {
    private final T subject;
    private final String query;
    private final Long regionId;

    public GeocoderRequest(@NotNull T subject, @NotNull String query) {
        this(subject, query, null);
    }

    public GeocoderRequest(@NotNull T subject, @NotNull String query, @Nullable Long regionId) {
        this.subject = subject;
        this.query = query;
        this.regionId = regionId;
    }

    public @NotNull T getSubject() {
        return subject;
    }

    public @NotNull String getQuery() {
        return query;
    }

    public @Nullable Long getRegionId() {
        return regionId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || !(o instanceof GeocoderRequest<?>)) {
            return false;
        }
        GeocoderRequest<?> that = (GeocoderRequest<?>) o;
        return Objects.equals(subject, that.subject);
    }

    @Override
    public int hashCode() {
        return Objects.hash(subject);
    }

    @Override
    public String toString() {
        return "GeocoderRequest{" +
            "subject=" + subject +
            ", query='" + query + '\'' +
            ", regionId='" + regionId + '\'' +
            '}';
    }
}
