package ru.yandex.passport.address;

import java.util.Objects;

import org.apache.commons.lang3.StringUtils;

public class GeocoderResponse {
    private final String zip;
    private final Integer regionId;
    private final String country;
    private final String city;
    private final String street;
    private final String building;
    private final GeoCoderPoint point;

    public GeocoderResponse(String zip, Integer regionId, String country, String city, String street, String building, GeoCoderPoint point) {
        this.zip = zip;
        this.regionId = regionId;
        this.country = country;
        this.city = city;
        this.street = street;
        this.building = building;
        this.point = point;
    }

    public String getZip() {
        return zip;
    }

    public Integer getRegionId() {
        return regionId;
    }

    public String getCountry() {
        return country;
    }

    public String getCity() {
        return city;
    }

    public String getStreet() {
        return street;
    }

    public String getBuilding() {
        return building;
    }

    public GeoCoderPoint getPoint() {
        return point;
    }

    public Address toAddress() {
        return toAddressBuilder().build();
    }

    public AddressBuilder toAddressBuilder() {
        return new AddressBuilder()
            .setRegionId(getRegionId())
            .setCountry(getCountry())
            .setCity(getCity())
            .setStreet(getStreet())
            .setBuilding(getBuilding())
            .setZip(getZip())
            .setGeoCoderPoint(getPoint());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || !(o instanceof GeocoderResponse)) {
            return false;
        }
        GeocoderResponse that = (GeocoderResponse) o;
        return Objects.equals(point, that.point);
    }

    @Override
    public int hashCode() {
        return Objects.hash(point);
    }

    @Override
    public String toString() {
        return "GeocoderResponse{" +
            "zip='" + zip + '\'' +
            ", regionId=" + regionId +
            ", country='" + country + '\'' +
            ", city='" + city + '\'' +
            ", street='" + street + '\'' +
            ", building='" + building + '\'' +
            ", point=" + point +
            '}';
    }

    public static GeocoderResponse.Builder builder() {
        return new GeocoderResponse.Builder();
    }

    public static class Builder {
        private String zip;
        private Integer regionId;
        private String country;
        private String city;
        private String street;
        private String building;
        private GeoCoderPoint point;

        public GeocoderResponse.Builder setZip(String zip) {
            this.zip = StringUtils.trimToNull(zip);
            return this;
        }

        public GeocoderResponse.Builder setRegionId(Integer regionId) {
            this.regionId = regionId;
            return this;
        }

        public GeocoderResponse.Builder setCountry(String country) {
            this.country = StringUtils.trimToNull(country);
            return this;
        }

        public GeocoderResponse.Builder setCity(String city) {
            this.city = StringUtils.trimToNull(city);
            return this;
        }

        public GeocoderResponse.Builder setStreet(String street) {
            this.street = StringUtils.trimToNull(street);
            return this;
        }

        public GeocoderResponse.Builder setBuilding(String building) {
            this.building = StringUtils.trimToNull(building);
            return this;
        }

        public GeocoderResponse.Builder setPoint(GeoCoderPoint point) {
            this.point = point;
            return this;
        }

        public GeocoderResponse build() {
            return new GeocoderResponse(zip, regionId, country, city, street, building, point);
        }
    }

}

