package ru.yandex.passport.address;

import java.time.OffsetDateTime;
import java.util.Objects;

import org.jetbrains.annotations.Nullable;

public class ImmutablePassportAddress extends ImmutableAddress
    implements PassportAddress
{
    private final String locale;
    private final Integer version;
    private final String formatVersion;
    private final String name;
    private final String uri;
    private final String label;
    private final String brandName;
    private final String phoneId;
    private final String geocoderName;
    private final String geocoderDescription;
    private final String geocoderObjectType;
    private final Boolean geocoderExact;
    private final String commentCourier;
    private final Long orgId;
    private final OffsetDateTime modificationTime;
    private final OffsetDateTime creationTime;
    private final boolean portalUid;
    private final boolean draft;

    public ImmutablePassportAddress(
        @Nullable AddressId id,
        AddressService ownerService,
        Integer regionId,
        Integer preciseRegionId,
        String country,
        String zip,
        String city,
        String metro,
        String street,
        String building,
        String entrance,
        String intercom,
        String floor,
        String room,
        Boolean cargoLift,
        String block,
        String estate,
        String wing,
        String km,
        String region,
        String type,
        String addressLine,
        @Nullable GeoCoderPoint geoCoderPoint,
        @Nullable String comment,
        @Nullable Location location,
        GeocoderStatus geocoderStatus,
        @Nullable String district,
        @Nullable OffsetDateTime lastTouchedTime,
        @Nullable String platform,
        String fullnessState,
        String locale,
        Integer version,
        @Nullable String formatVersion,
        @Nullable String name,
        @Nullable String uri,
        @Nullable String label,
        @Nullable String brandName,
        @Nullable String phoneId,
        @Nullable String geocoderName,
        @Nullable String geocoderDescription,
        @Nullable String geocoderObjectType,
        @Nullable Boolean geocoderExact,
        @Nullable String commentCourier,
        @Nullable Long orgId,
        @Nullable OffsetDateTime modificationTime,
        @Nullable OffsetDateTime creationTime,
        boolean draft,
        boolean portalUid)
    {
        super(id,
            ownerService,
            regionId,
            preciseRegionId,
            country,
            zip,
            city,
            metro,
            street,
            building,
            entrance,
            intercom,
            floor,
            room,
            cargoLift,
            block,
            estate,
            wing,
            km,
            region,
            type,
            addressLine,
            geoCoderPoint,
            comment,
            location,
            geocoderStatus,
            district,
            lastTouchedTime,
            platform,
            fullnessState);
        this.locale = locale;
        this.version = version;
        this.formatVersion = formatVersion;
        this.name = name;
        this.uri = uri;
        this.label = label;
        this.brandName = brandName;
        this.phoneId = phoneId;
        this.geocoderName = geocoderName;
        this.geocoderDescription = geocoderDescription;
        this.geocoderObjectType = geocoderObjectType;
        this.geocoderExact = geocoderExact;
        this.commentCourier = commentCourier;
        this.orgId = orgId;
        this.modificationTime = modificationTime;
        this.creationTime = creationTime;
        this.draft = draft;
        this.portalUid = portalUid;
    }

    public static PassportAddressBuilder copy(ImmutablePassportAddress address) {
        return new PassportAddressBuilder()
            .setId(address.id())
            .setOwnerService(address.ownerService())
            .setRegionId(address.regionId())
            .setPreciseRegionId(address.preciseRegionId())
            .setCountry(address.country())
            .setZip(address.zip())
            .setCity(address.city())
            .setMetro(address.metro())
            .setStreet(address.street())
            .setBuilding(address.building())
            .setEntrance(address.entrance())
            .setIntercom(address.intercom())
            .setFloor(address.floor())
            .setRoom(address.room())
            .setCargoLift(address.cargoLift())
            .setMarketAddressLine(address.addressLine())
            .setBlock(address.block())
                   .setDraft(address.draft())
            .setEstate(address.estate())
            .setWing(address.wing())
            .setKm(address.km())
            .setRegion(address.region())
            .setType(address.subtype())
            .setGeoCoderPoint(address.geoCoderPoint())
            .setComment(address.comment())
            .setLocation(address.location())
            .setGeocoderStatus(address.geocoderStatus())
            .setDistrict(address.district())
            .setLastTouchedTime(address.lastTouchedTime())
            .setPlatform(address.platform())
            .setFullnessState(address.fullnessState())
            .setLocale(address.locale())
            .setVersion(address.version())
            .setFormatVersion(address.formatVersion())
            .setName(address.name())
            .setUri(address.uri())
            .setLabel(address.label())
            .setBrandName(address.brandName())
            .setPhoneId(address.phoneId())
            .setGeocoderName(address.geocoderName())
            .setGeocoderDescription(address.geocoderDescription())
            .setGeocoderObjectType(address.geocoderObjectType())
            .setGeocoderExact(address.geocoderExact())
            .setCommentCourier(address.commentCourier())
            .setOrgId(address.orgId())
            .setModificationTime(address.modificationTime())
            .setCreationTime(address.creationTime());
    }

    @Override
    public String locale() {
        return locale;
    }

    @Override
    public Integer version() {
        return version;
    }

    @Override
    public String formatVersion() {
        return formatVersion;
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public String uri() {
        return uri;
    }

    @Override
    public String label() {
        return label;
    }

    @Override
    public String brandName() {
        return brandName;
    }

    @Override
    public String phoneId() {
        return phoneId;
    }

    @Override
    public String geocoderName() {
        return geocoderName;
    }

    @Override
    public String geocoderDescription() {
        return geocoderDescription;
    }

    @Override
    public String geocoderObjectType() {
        return geocoderObjectType;
    }

    @Override
    public Boolean geocoderExact() {
        return geocoderExact;
    }

    @Override
    public String commentCourier() {
        return commentCourier;
    }

    @Override
    public Long orgId() {
        return orgId;
    }

    @Override
    public OffsetDateTime modificationTime() {
        return modificationTime;
    }

    @Override
    public OffsetDateTime creationTime() {
        return creationTime;
    }

    @Override
    public boolean draft() {
        return draft;
    }

    @Override
    public boolean isPortalUid() {
        return portalUid;
    }

    @Override
    public String toString() {
        return "PassportAddress{" +
            "id='" + id + '\'' +
            ", regionId=" + regionId +
            ", preciseRegionId=" + preciseRegionId +
            ", country='" + country + '\'' +
            ", zip='" + zip + '\'' +
            ", city='" + city + '\'' +
            ", metro='" + metro + '\'' +
            ", street='" + street + '\'' +
            ", building='" + building + '\'' +
            ", entrance='" + entrance + '\'' +
            ", intercom='" + intercom + '\'' +
            ", floor='" + floor + '\'' +
            ", room='" + room + '\'' +
            ", cargoLift=" + cargoLift +
            ", addressLine='" + addressLine + '\'' +
            ", block='" + block + '\'' +
            ", estate='" + estate + '\'' +
            ", wing='" + wing + '\'' +
            ", km='" + km + '\'' +
            ", region='" + region + '\'' +
            ", type=" + type +
            ", geoCoderPoint=" + geoCoderPoint +
            ", comment=" + comment +
            ", location=" + location +
            ", geocoderStatus=" + geocoderStatus +
            ", district=" + district +
            ", platform=" + platform +
            ", fullnessState=" + fullnessState +
            ", locale='" + locale + '\'' +
            ", version=" + version +
            ", formatVersion='" + formatVersion + '\'' +
            ", name='" + name + '\'' +
            ", uri='" + uri + '\'' +
            ", label='" + label + '\'' +
            ", brandName='" + brandName + '\'' +
            ", phoneId='" + phoneId + '\'' +
            ", geocoderName='" + geocoderName + '\'' +
            ", geocoderDescription='" + geocoderDescription + '\'' +
            ", geocoderObjectType='" + geocoderObjectType + '\'' +
            ", geocoderExact=" + geocoderExact +
            ", commentCourier='" + commentCourier + '\'' +
            ", orgId=" + orgId +
            ", modificationTime=" + modificationTime +
            ", creationTime=" + creationTime +
            ", draft=" + draft +
            ", portal_uid=" + portalUid +
            '}';
    }

    // TODO
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ImmutablePassportAddress)) {
            return false;
        }

        ImmutablePassportAddress address = (ImmutablePassportAddress) o;

        if (Objects.equals(geoCoderPoint, address.geoCoderPoint)) {
            return Objects.equals(entrance, address.entrance) &&
                Objects.equals(intercom, address.intercom) &&
                Objects.equals(floor, address.floor) &&
                Objects.equals(room, address.room) &&
                Objects.equals(cargoLift, address.cargoLift);
        } else {
            return Objects.equals(regionId, address.regionId) &&
                Objects.equals(preciseRegionId, address.preciseRegionId) &&
                Objects.equals(addressLine, address.addressLine) &&
                Objects.equals(country, address.country) &&
                Objects.equals(zip, address.zip) &&
                Objects.equals(city, address.city) &&
                Objects.equals(metro, address.metro) &&
                Objects.equals(street, address.street) &&
                Objects.equals(building, address.building) &&
                Objects.equals(block, address.block) &&
                Objects.equals(estate, address.estate) &&
                Objects.equals(wing, address.wing) &&
                Objects.equals(km, address.km) &&
                Objects.equals(region, address.region) &&
                Objects.equals(entrance, address.entrance) &&
                Objects.equals(intercom, address.intercom) &&
                Objects.equals(floor, address.floor) &&
                Objects.equals(room, address.room) &&
                Objects.equals(type, address.type) &&
                Objects.equals(cargoLift, address.cargoLift);
        }
    }

    // TODO
    @Override
    public int hashCode() {
        if (geoCoderPoint != null) {
            return Objects.hash(geoCoderPoint, entrance, intercom, floor, room, cargoLift);
        } else {
            return Objects.hash(addressLine, regionId, preciseRegionId, country, zip, city, metro, street, block,
                estate, wing, km, region, building, entrance, intercom, floor, room, type, cargoLift);
        }
    }
}
