package ru.yandex.passport.address;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.passport.AddressContext;

public class ListAddressContext extends AddressContext {
    private final int length;
    private final PassportAddressUser user;

    public ListAddressContext(final ProxySession session) throws BadRequestException {
        super(session);

        length = session.params().getInt("length", 20);
        user = PassportAddressUser.parse(session.params());
    }

    public int length() {
        return length;
    }

    public PassportAddressUser passportUser() {
        return user;
    }
}
