package ru.yandex.passport.address;

import ru.yandex.common.util.geocoder.GeoSearchParams;

public enum Locale {
    RU(GeoSearchParams.Language.RU),
    EN(GeoSearchParams.Language.US),
    UK(GeoSearchParams.Language.UKR),
    BE(GeoSearchParams.Language.BEL),
    TR(GeoSearchParams.Language.TR),
    ;

    private GeoSearchParams.Language language;
    private String lowercaseName;

    Locale(final GeoSearchParams.Language language) {
        this.language = language;
        this.lowercaseName = name().toLowerCase(java.util.Locale.ROOT);
    }

    @Override
    public String toString() {
        return lowercaseName;
    }

    public GeoSearchParams.Language language() {
        return language;
    }
}
