package ru.yandex.passport.address;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class Location implements JsonValue {
    private final BigDecimal latitude;
    private final BigDecimal longitude;

    public Location(BigDecimal latitude, BigDecimal longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public BigDecimal getLatitude() {
        return latitude;
    }

    public BigDecimal getLongitude() {
        return longitude;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Location)) {
            return false;
        }
        Location location = (Location) o;
        return Objects.equals(latitude, location.latitude) &&
            Objects.equals(longitude, location.longitude);
    }

    @Override
    public int hashCode() {
        return Objects.hash(latitude, longitude);
    }

    @Override
    public String toString() {
        return "Location{" +
            "latitude=" + latitude +
            ", longitude=" + longitude +
            '}';
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        if (latitude == null && longitude == null) {
            writer.nullValue();
        } else {
            writer.startObject();
            writer.key("latitude");
            writer.value(latitude);
            writer.key("longitude");
            writer.value(longitude);
            writer.endObject();
        }
    }
}
