package ru.yandex.passport.address;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.OffsetDateTime;

import ru.yandex.passport.RegionServiceWrapper;

public class MarketAddressBuilder extends AddressBuilder {
    public static MarketAddressBuilder build(final PassportAddressUser user, final ResultSet result) throws SQLException {
        return build(user.userType(), user.userId(), result);
    }

    public static MarketAddressBuilder build(
        final String userType,
        final Object userId,
        final ResultSet result)
        throws SQLException
    {
        MarketAddressBuilder builder = new MarketAddressBuilder();
        builder.setRegionId(result.getInt("region_id"));
        builder.setRegion(RegionServiceWrapper.findRegionName(builder.regionId()));
        builder.setCountry(result.getString("country"));
        builder.setZip(result.getString("zip"));
        builder.setCity(result.getString("city"));
        builder.setOwnerService(AddressService.MARKET);
        builder.setType("address");
        //builder.setMetro(result.getString("metro"));
        builder.setStreet(result.getString("street"));
        builder.setBuilding(result.getString("building"));
        builder.setIntercom(result.getString("intercom"));
        builder.setFloor(result.getString("floor"));
        builder.setRoom(result.getString("room"));
        //builder.setCargoLift(result.getBoolean("ca"))
        builder.setLocation(
            new Location(
                result.getBigDecimal("latitude"),
                result.getBigDecimal("longitude")));
        builder.setDistrict(result.getString("district"));
        builder.setLastTouchedTime(result.getObject("last_touched_time", OffsetDateTime.class));
        builder.setId(new AddressId(userType, userId, builder.ownerService(), result.getString(
            "object_key")));
        return builder;
    }
}
