package ru.yandex.passport.address;

import java.io.IOException;
import java.time.OffsetDateTime;

import ru.yandex.json.writer.JsonWriterBase;

public interface PassportAddress extends Address {
    String locale();

    Integer version();

    String formatVersion();

    String name();

    String uri();

    String label();

    String brandName();

    String phoneId();

    String geocoderName();

    String geocoderDescription();

    String geocoderObjectType();

    Boolean geocoderExact();

    String commentCourier();

    Long orgId();

    OffsetDateTime modificationTime();

    OffsetDateTime creationTime();

    boolean draft();

    boolean isPortalUid();

    @Override
    default void writeValue(final JsonWriterBase writer) throws IOException {
        PassportAddressDto.write(this, writer);
    }
}
