package ru.yandex.passport.address;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

import io.vertx.sqlclient.Row;

import ru.yandex.passport.AddressServiceParser;
import ru.yandex.passport.RegionServiceWrapper;

public class PassportAddressBuilder extends AddressBuilder
    implements PassportAddress
{
    private String locale;
    private Integer version;
    private String formatVersion;
    private String name;
    private String uri;
    private String label;
    private String brandName;
    private String phoneId;
    private String geocoderName;
    private String geocoderDescription;
    private String geocoderObjectType;
    private Boolean geocoderExact;
    private String commentCourier;
    private Long orgId;
    private OffsetDateTime modificationTime;
    private OffsetDateTime creationTime;
    private boolean portalUid;
    private boolean draft;

    @Override
    public boolean isPortalUid() {
        return portalUid;
    }

    public void setPortalUid(boolean portalUid) {
        this.portalUid = portalUid;
    }

    @Override
    public boolean draft() {
        return draft;
    }

    public PassportAddressBuilder setDraft(boolean draft) {
        this.draft = draft;
        return this;
    }

    @Override
    public String locale() {
        return locale;
    }

    @Override
    public Integer version() {
        return version;
    }

    @Override
    public String formatVersion() {
        return formatVersion;
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public String uri() {
        return uri;
    }

    @Override
    public String label() {
        return label;
    }

    @Override
    public String brandName() {
        return brandName;
    }

    @Override
    public String phoneId() {
        return phoneId;
    }

    @Override
    public String geocoderName() {
        return geocoderName;
    }

    @Override
    public String geocoderDescription() {
        return geocoderDescription;
    }

    @Override
    public String geocoderObjectType() {
        return geocoderObjectType;
    }

    @Override
    public Boolean geocoderExact() {
        return geocoderExact;
    }

    @Override
    public String commentCourier() {
        return commentCourier;
    }

    @Override
    public Long orgId() {
        return orgId;
    }

    @Override
    public OffsetDateTime modificationTime() {
        return modificationTime;
    }

    @Override
    public OffsetDateTime creationTime() {
        return creationTime;
    }

    @Override
    public PassportAddressBuilder setId(final AddressId id) {
        this.id = id;
        return this;
    }

    public PassportAddressBuilder setSeqId(final int seqId) {
        this.seqId = seqId;
        return this;
    }

    @Override
    public PassportAddressBuilder setOwnerService(final AddressService service) {
        this.ownerService = service;
        return this;
    }

    @Override
    public PassportAddressBuilder setGeoCoderPoint(GeoCoderPoint geoCoderPoint) {
        this.geoCoderPoint = geoCoderPoint;
        return this;
    }

    @Override
    public PassportAddressBuilder setCargoLift(Boolean cargoLift) {
        this.cargoLift = cargoLift;
        return this;
    }

    @Override
    public PassportAddressBuilder setBlock(String block) {
        this.block = block;
        return this;
    }

    @Override
    public PassportAddressBuilder setRegionId(Integer regionId) {
        this.regionId = regionId;
        return this;
    }

    @Override
    public PassportAddressBuilder setPreciseRegionId(Integer preciseRegionId) {
        this.preciseRegionId = preciseRegionId;
        return this;
    }

    @Override
    public PassportAddressBuilder setCountry(String country) {
        this.country = country;
        return this;
    }

    @Override
    public PassportAddressBuilder setZip(String zip) {
        this.zip = zip;
        return this;
    }

    @Override
    public PassportAddressBuilder setCity(String city) {
        this.city = city;
        return this;
    }

    @Override
    public PassportAddressBuilder setMetro(String metro) {
        this.metro = metro;
        return this;
    }

    @Override
    public PassportAddressBuilder setStreet(String street) {
        this.street = street;
        return this;
    }

    @Override
    public PassportAddressBuilder setBuilding(String building) {
        this.building = building;
        return this;
    }

    @Override
    public PassportAddressBuilder setEntrance(String entrance) {
        this.entrance = entrance;
        return this;
    }

    @Override
    public PassportAddressBuilder setIntercom(String intercom) {
        this.intercom = intercom;
        return this;
    }

    @Override
    public PassportAddressBuilder setFloor(String floor) {
        this.floor = floor;
        return this;
    }

    @Override
    public PassportAddressBuilder setRoom(String room) {
        this.room = room;
        return this;
    }

    @Override
    public PassportAddressBuilder setEstate(String estate) {
        this.estate = estate;
        return this;
    }

    @Override
    public PassportAddressBuilder setWing(String wing) {
        this.wing = wing;
        return this;
    }

    @Override
    public PassportAddressBuilder setKm(String km) {
        this.km = km;
        return this;
    }

    @Override
    public PassportAddressBuilder setRegion(String region) {
        this.region = region;
        return this;
    }

    @Override
    public PassportAddressBuilder setType(String type) {
        this.type = type;
        return this;
    }

    @Override
    public PassportAddressBuilder setMarketAddressLine(String addressLine) {
        this.addressLine = addressLine;
        return this;
    }

    @Override
    public PassportAddressBuilder setComment(String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public PassportAddressBuilder setLocation(Location location) {
        this.location = location;
        return this;
    }

    @Override
    public PassportAddressBuilder setGeocoderStatus(GeocoderStatus geocoderStatus) {
        this.geocoderStatus = geocoderStatus;
        return this;
    }

    @Override
    public PassportAddressBuilder setDistrict(String district) {
        this.district = district;
        return this;
    }

    @Override
    public PassportAddressBuilder setLastTouchedTime(OffsetDateTime lastTouchedTime) {
        this.lastTouchedTime = lastTouchedTime;
        return this;
    }

    @Override
    public PassportAddressBuilder setPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    @Override
    public PassportAddressBuilder setFullnessState(String fullnessState) {
        this.fullnessState = fullnessState;
        return this;
    }

    public PassportAddressBuilder setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public PassportAddressBuilder setVersion(Integer version) {
        this.version = version;
        return this;
    }

    public PassportAddressBuilder setFormatVersion(String formatVersion) {
        this.formatVersion = formatVersion;
        return this;
    }

    public PassportAddressBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public PassportAddressBuilder setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public PassportAddressBuilder setLabel(String label) {
        this.label = label;
        return this;
    }

    public PassportAddressBuilder setBrandName(String brandName) {
        this.brandName = brandName;
        return this;
    }

    public PassportAddressBuilder setPhoneId(String phoneId) {
        this.phoneId = phoneId;
        return this;
    }

    public PassportAddressBuilder setGeocoderName(String geocoderName) {
        this.geocoderName = geocoderName;
        return this;
    }

    public PassportAddressBuilder setGeocoderDescription(String geocoderDescription) {
        this.geocoderDescription = geocoderDescription;
        return this;
    }

    public PassportAddressBuilder setGeocoderObjectType(String geocoderObjectType) {
        this.geocoderObjectType = geocoderObjectType;
        return this;
    }

    public PassportAddressBuilder setGeocoderExact(Boolean geocoderExact) {
        this.geocoderExact = geocoderExact;
        return this;
    }

    public PassportAddressBuilder setCommentCourier(String commentCourier) {
        this.commentCourier = commentCourier;
        return this;
    }

    public PassportAddressBuilder setOrgId(Long orgId) {
        this.orgId = orgId;
        return this;
    }

    public PassportAddressBuilder setModificationTime(OffsetDateTime modificationTime) {
        this.modificationTime = modificationTime;
        return this;
    }

    public PassportAddressBuilder setCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @Override
    public ImmutablePassportAddress build() {
        return new ImmutablePassportAddress(id, ownerService, regionId, preciseRegionId, country,
            zip, city, metro, street, building, entrance, intercom, floor, room, cargoLift,
            block, estate, wing, km, region, type, addressLine, geoCoderPoint, comment,
            location, geocoderStatus, district, lastTouchedTime, platform, fullnessState,
            locale, version, formatVersion, name, uri, label, brandName, phoneId, geocoderName,
            geocoderDescription, geocoderObjectType, geocoderExact, commentCourier, orgId,
            modificationTime, creationTime, draft, portalUid);
    }

    @Override
    public String toString() {
        return "PassportAddressBuilder{" +
                   "id=" + id +
                   ", ownerService=" + ownerService +
                   ", regionId=" + regionId +
                   ", preciseRegionId=" + preciseRegionId +
                   ", country='" + country + '\'' +
                   ", zip='" + zip + '\'' +
                   ", city='" + city + '\'' +
                   ", metro='" + metro + '\'' +
                   ", street='" + street + '\'' +
                   ", building='" + building + '\'' +
                   ", entrance='" + entrance + '\'' +
                   ", intercom='" + intercom + '\'' +
                   ", floor='" + floor + '\'' +
                   ", room='" + room + '\'' +
                   ", cargoLift=" + cargoLift +
                   ", block='" + block + '\'' +
                   ", estate='" + estate + '\'' +
                   ", wing='" + wing + '\'' +
                   ", km='" + km + '\'' +
                   ", region='" + region + '\'' +
                   ", addressLine='" + addressLine + '\'' +
                   ", type='" + type + '\'' +
                   ", geoCoderPoint=" + geoCoderPoint +
                   ", comment='" + comment + '\'' +
                   ", location=" + location +
                   ", geocoderStatus=" + geocoderStatus +
                   ", district='" + district + '\'' +
                   ", lastTouchedTime=" + lastTouchedTime +
                   ", platform='" + platform + '\'' +
                   ", fullnessState='" + fullnessState + '\'' +
                   ", seqId=" + seqId +
                   ", locale='" + locale + '\'' +
                   ", version=" + version +
                   ", formatVersion='" + formatVersion + '\'' +
                   ", name='" + name + '\'' +
                   ", uri='" + uri + '\'' +
                   ", label='" + label + '\'' +
                   ", brandName='" + brandName + '\'' +
                   ", phoneId='" + phoneId + '\'' +
                   ", geocoderName='" + geocoderName + '\'' +
                   ", geocoderDescription='" + geocoderDescription + '\'' +
                   ", geocoderObjectType='" + geocoderObjectType + '\'' +
                   ", geocoderExact=" + geocoderExact +
                   ", commentCourier='" + commentCourier + '\'' +
                   ", orgId=" + orgId +
                   ", modificationTime=" + modificationTime +
                   ", creationTime=" + creationTime +
                   ", portalUid=" + portalUid +
                   ", draft=" + draft +
                   '}';
    }

    public static PassportAddressBuilder build(
        final PassportAddressUser user,
        final ResultSet result)
        throws SQLException
    {
        return build(user.userType(), user.userId(), result);
    }

    public static PassportAddressBuilder build(
        final String userType,
        final Object userId,
        final ResultSet result)
        throws SQLException
    {
        PassportAddressBuilder builder = new PassportAddressBuilder();
        Integer regionId = (Integer) result.getObject("region_id");
        builder.setRegionId(regionId);
        builder.region(RegionServiceWrapper.findRegionName(regionId));
        builder.setCountry(result.getString("country"));
        builder.setZip(result.getString("zip"));
        builder.setCity(result.getString("city"));
        String ownerServiceName = result.getString("owner_service");
        builder.setOwnerService(AddressServiceParser.INSTANCE.apply(ownerServiceName));
        builder.setType(result.getString("subtype"));
        //builder.setMetro(result.getString("metro"));
        builder.setStreet(result.getString("street"));
        builder.setBuilding(result.getString("building"));
        builder.setEntrance(result.getString("entrance"));
        builder.setComment(result.getString("comment"));
        builder.setIntercom(result.getString("intercom"));
        builder.setFloor(result.getString("floor"));
        builder.setRoom(result.getString("room"));
        //builder.setCargoLift(result.getBoolean("ca"))
        builder.setLocation(
            new Location(
                result.getBigDecimal("latitude"),
                result.getBigDecimal("longitude")));
        builder.setDistrict(result.getString("district"));
        builder.setLastTouchedTime(result.getObject("last_touched_time", OffsetDateTime.class));
        builder.setId(new AddressId(userType, userId, builder.ownerService(), result.getString("object_key")));
        //    AddressId.toString(user.userType(), user.userId().toString(), ownerService, result.getString("address_id")));
        builder.setLocale(result.getString("locale"));
        builder.setVersion((Integer) result.getObject("version"));
        builder.setFormatVersion(result.getString("format_version"));
        builder.setName(result.getString("name"));
        builder.setUri(result.getString("uri"));
        builder.setLabel(result.getString("label"));
        builder.setBrandName(result.getString("brand_name"));
        builder.setPhoneId(result.getString("phone_id"));
        builder.setGeocoderName(result.getString("geocoder_name"));
        builder.setGeocoderDescription(result.getString("geocoder_description"));
        builder.setGeocoderObjectType(result.getString("geocoder_object_type"));
        builder.setGeocoderExact((Boolean) result.getObject("geocoder_exact"));
        builder.setCommentCourier(result.getString("comment_courier"));
        Long orgId = result.getLong("org_id");
        if (result.wasNull()) {
            builder.setOrgId(null);
        } else {
            builder.setOrgId(orgId);
        }

        builder.setModificationTime(result.getObject("modification_time", OffsetDateTime.class));
        builder.setCreationTime(result.getObject("creation_time", OffsetDateTime.class));
        return builder;
    }


    public static PassportAddressBuilder build(
        final PassportAddressUser user,
        final Row result)
        throws SQLException
    {
        return build(user.userType(), user.userId(), result);
    }

    public static PassportAddressBuilder build(
        final String userType,
        final Object userId,
        final Row result)
    {
        PassportAddressBuilder builder = new PassportAddressBuilder();
        Integer regionId = result.getInteger("region_id");
        builder.setRegionId(regionId);
        builder.region(RegionServiceWrapper.findRegionName(regionId));
        builder.setCountry(result.getString("country"));
        builder.setZip(result.getString("zip"));
        builder.setCity(result.getString("city"));
        String ownerServiceName = result.getString("owner_service");
        builder.setOwnerService(AddressServiceParser.INSTANCE.apply(ownerServiceName));
        builder.setType(result.getString("subtype"));
        //builder.setMetro(result.getString("metro"));
        builder.setStreet(result.getString("street"));
        builder.setBuilding(result.getString("building"));
        builder.setEntrance(result.getString("entrance"));
        builder.setComment(result.getString("comment"));
        builder.setIntercom(result.getString("intercom"));
        builder.setFloor(result.getString("floor"));
        builder.setRoom(result.getString("room"));
        //builder.setCargoLift(result.getBoolean("ca"))
        builder.setLocation(
            new Location(
                result.getBigDecimal("latitude"),
                result.getBigDecimal("longitude")));
        builder.setDistrict(result.getString("district"));
        builder.setLastTouchedTime(result.getOffsetDateTime("last_touched_time"));
        builder.setId(new AddressId(userType, userId, builder.ownerService(), result.getString("object_key")));
        //    AddressId.toString(user.userType(), user.userId().toString(), ownerService, result.getString("address_id")));
        builder.setLocale(result.getString("locale"));
        builder.setVersion(result.getInteger("version"));
        builder.setFormatVersion(result.getString("format_version"));
        builder.setName(result.getString("name"));
        builder.setUri(result.getString("uri"));
        builder.setLabel(result.getString("label"));
        builder.setBrandName(result.getString("brand_name"));
        builder.setPhoneId(result.getString("phone_id"));
        builder.setGeocoderName(result.getString("geocoder_name"));
        builder.setGeocoderDescription(result.getString("geocoder_description"));
        builder.setGeocoderObjectType(result.getString("geocoder_object_type"));
        builder.setGeocoderExact(result.getBoolean("geocoder_exact"));
        builder.setCommentCourier(result.getString("comment_courier"));
        Long orgId = result.getLong("org_id");
        if (orgId == null) {
            builder.setOrgId(null);
        } else {
            builder.setOrgId(orgId);
        }

        builder.setModificationTime(result.getLocalDateTime("modification_time").atOffset(ZoneOffset.UTC));
        builder.setCreationTime(result.getLocalDateTime("creation_time").atOffset(ZoneOffset.UTC));
        return builder;
    }

    public boolean validForGeocoder() {
        return addressLine != null
            || country != null && city != null && (street != null ||  district != null) && building != null;
    }

}

