package ru.yandex.passport.address;

import java.io.IOException;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.parser.uri.CgiParams;

public class PassportAddressUser implements JsonValue {
    private final Long userId;
    private final String userType;

    public PassportAddressUser(final long userId, final String userType) {
        this.userId = userId;
        this.userType = userType;
    }

    public Long userId() {
        return userId;
    }

    public String userType() {
        return userType;
    }

    public static final PassportAddressUser parse(final CgiParams params) throws BadRequestException {
        Long userId = params.getLong("user_id");
        String userType = params.getString("user_type", FixedUserTypes.PASSPORT.value());
        return new PassportAddressUser(userId, userType);
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.key("user_id");
        writer.value(String.valueOf(userId));
        writer.key("user_type");
        writer.value(userType);
    }
}
