package ru.yandex.passport.address;

import ru.yandex.passport.ServiceConfigDefault;

public class ServiceConfigBuilder implements ServiceConfig {
    private boolean useGeocoderOnUpdate;
    private boolean serviceKeepHisId;

    public ServiceConfigBuilder(final ServiceConfig defaults) {
        this.useGeocoderOnUpdate = defaults.useGeocoderOnUpdate();
        this.serviceKeepHisId = defaults.serviceKeepHisId();
    }

    public ServiceConfigBuilder() {
        this(ServiceConfigDefault.INSTANCE);
    }

    @Override
    public boolean useGeocoderOnUpdate() {
        return useGeocoderOnUpdate;
    }

    public ServiceConfigBuilder useGeocoderOnUpdate(final boolean useGeocoderOnUpdate) {
        this.useGeocoderOnUpdate = useGeocoderOnUpdate;
        return this;
    }

    @Override
    public boolean serviceKeepHisId() {
        return serviceKeepHisId;
    }

    public ServiceConfigBuilder serviceKeepHisId(final boolean serviceKeepHisId) {
        this.serviceKeepHisId = serviceKeepHisId;
        return this;
    }
}
