package ru.yandex.passport.address.config;

import ru.yandex.client.pg.config.PgClientConfig;
import ru.yandex.client.pg.config.PgClientConfigBuilder;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigBuilder;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.msal.pool.AddressPgConfig;
import ru.yandex.search.msal.pool.AddressPgConfigBuilder;

public abstract class AbstractAddressProxyConfigBuilder<T extends AbstractAddressProxyConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements AddressProxyConfig
{
    private AddressPgConfigBuilder marketDbConfig;
    private AddressPgConfigBuilder passportDbConfig;
    private PgClientConfigBuilder passportPgClientConfig;
    private URIConfigBuilder geocoderConfig;
    private HttpHostConfigBuilder blackboxConfig;
    private HttpHostConfigBuilder homeWorkDatasyncConfig;
    private HttpHostConfigBuilder deliveryDatasyncConfig;
    private RegionBaseConfigBuilder regionBaseConfig;

    protected AbstractAddressProxyConfigBuilder(final AddressProxyConfig config) {
        super(config);
        marketDbConfig(config.marketDbConfig());
        passportDbConfig(config.passportDbConfig());
        passportPgClientConfig(config.passportPgClientConfig());
        geocoderConfig(config.geocoderConfig());
        blackboxConfig(config.blackboxConfig());
        deliveryDatasyncConfig(config.deliveryDatasyncConfig());
        homeWorkDatasyncConfig(config.homeWorkDatasyncConfig());
        regionBaseConfig(config.regionBaseConfig());
    }

    protected AbstractAddressProxyConfigBuilder(
        final IniConfig config,
        final AddressProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        this.marketDbConfig =
            new AddressPgConfigBuilder(
                config.section("market-db"),
                defaults.marketDbConfig());
        this.passportDbConfig =
            new AddressPgConfigBuilder(
                config.section("passport-db"),
                defaults.passportDbConfig());
        this.passportPgClientConfig =
            new PgClientConfigBuilder(
                config.section("passport-pgclient"),
                defaults.passportPgClientConfig());
        this.geocoderConfig =
            new URIConfigBuilder(
                config.section("geocoder"),
                defaults.geocoderConfig());
        this.blackboxConfig =
            new HttpHostConfigBuilder(
                config.section("blackbox"),
                defaults.blackboxConfig());
        this.deliveryDatasyncConfig =
            new HttpHostConfigBuilder(
                config.section("delivery-datasync"),
                defaults.deliveryDatasyncConfig());
        this.homeWorkDatasyncConfig =
            new HttpHostConfigBuilder(
                config.section("homework-datasync"),
                defaults.homeWorkDatasyncConfig());
        this.regionBaseConfig =
            new RegionBaseConfigBuilder(
                config.section("region-base"),
                defaults.regionBaseConfig());
    }

    @Override()
    public AddressPgConfigBuilder marketDbConfig() {
        return marketDbConfig;
    }

    public T marketDbConfig(final AddressPgConfig value) {
        this.marketDbConfig = new AddressPgConfigBuilder(
            value);
        return self();
    }

    @Override()
    public AddressPgConfigBuilder passportDbConfig() {
        return passportDbConfig;
    }

    public T passportDbConfig(final AddressPgConfig value) {
        this.passportDbConfig = new AddressPgConfigBuilder(
            value);
        return self();
    }

    @Override()
    public PgClientConfigBuilder passportPgClientConfig() {
        return passportPgClientConfig;
    }

    public T passportPgClientConfig(final PgClientConfig value) {
        this.passportPgClientConfig = new PgClientConfigBuilder(
            value);
        return self();
    }

    @Override
    public URIConfigBuilder geocoderConfig() {
        return geocoderConfig;
    }

    public T geocoderConfig(final URIConfig geocoderConfig) {
        this.geocoderConfig = new URIConfigBuilder(geocoderConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder blackboxConfig() {
        return blackboxConfig;
    }

    public T blackboxConfig(final HttpHostConfig blackboxConfig) {
        this.blackboxConfig = new HttpHostConfigBuilder(blackboxConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder homeWorkDatasyncConfig() {
        return homeWorkDatasyncConfig;
    }

    public T homeWorkDatasyncConfig(final HttpHostConfig datasyncConfig) {
        this.homeWorkDatasyncConfig = new HttpHostConfigBuilder(datasyncConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder deliveryDatasyncConfig() {
        return deliveryDatasyncConfig;
    }

    public T deliveryDatasyncConfig(final HttpHostConfig datasyncConfig) {
        this.deliveryDatasyncConfig = new HttpHostConfigBuilder(datasyncConfig);
        return self();
    }

    @Override
    public RegionBaseConfigBuilder regionBaseConfig() {
        return regionBaseConfig;
    }

    public T regionBaseConfig(final RegionBaseConfig regionBaseConfig) {
        this.regionBaseConfig = new RegionBaseConfigBuilder(regionBaseConfig);
        return self();
    }
}
