package ru.yandex.passport.address.config;

import java.net.URL;

import ru.yandex.http.config.AbstractHttpTargetConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractRegionBaseConfigBuilder
    <T extends AbstractRegionBaseConfigBuilder<T>>
     extends AbstractHttpTargetConfigBuilder<T>
     implements RegionBaseConfig
{
    private URL url;

    protected AbstractRegionBaseConfigBuilder(final RegionBaseConfig config) {
        super(config);
        url(config.url());
    }

    protected AbstractRegionBaseConfigBuilder(
        final IniConfig config,
        final RegionBaseConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        this.url = config.get("url", defaults.url(), URL::new);
    }

    @Override()
    public URL url() {
        return url;
    }

    public T url(final URL value) {
        this.url = value;
        return self();
    }
}
