package ru.yandex.passport.address.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class AddressProxyConfigBuilder
     extends AbstractAddressProxyConfigBuilder<AddressProxyConfigBuilder>
{
    public AddressProxyConfigBuilder() {
        this(AddressProxyConfigDefaults.INSTANCE);
    }

    public AddressProxyConfigBuilder(final AddressProxyConfig config) {
        super(config);
    }

    public AddressProxyConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, AddressProxyConfigDefaults.INSTANCE);
    }

    public AddressProxyConfigBuilder(
        final IniConfig config,
        final AddressProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableAddressProxyConfig build() throws ConfigException {
        return new ImmutableAddressProxyConfig(
            this);
    }

    @Override
    public AddressProxyConfigBuilder self() {
        return this;
    }
}
