package ru.yandex.passport.address.config;

import ru.yandex.client.pg.config.PgClientConfig;
import ru.yandex.client.pg.config.PgClientConfigDefaults;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigDefaults;
import ru.yandex.http.util.server.HttpProxyConfigDefaults;
import ru.yandex.search.msal.pool.AddressPgConfig;
import ru.yandex.search.msal.pool.AddressPgConfigDefaults;

public class AddressProxyConfigDefaults
    extends HttpProxyConfigDefaults
    implements AddressProxyConfig
{
    public static final AddressProxyConfigDefaults INSTANCE =
        new AddressProxyConfigDefaults();

    protected AddressProxyConfigDefaults() {
        super();
    }

    @Override
    public AddressPgConfig marketDbConfig() {
        return AddressPgConfigDefaults.INSTANCE;
    }

    @Override
    public AddressPgConfig passportDbConfig() {
        return AddressPgConfigDefaults.INSTANCE;
    }

    @Override
    public PgClientConfig passportPgClientConfig() {
        return PgClientConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfig geocoderConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig blackboxConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig deliveryDatasyncConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig homeWorkDatasyncConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public RegionBaseConfig regionBaseConfig() {
        return RegionBaseConfigDefaults.INSTANCE;
    }
}
