package ru.yandex.passport.address.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

import ru.yandex.passport.ReadWriteRights;
import ru.yandex.passport.ServiceConfigDefault;
import ru.yandex.passport.address.AddressService;
import ru.yandex.passport.address.ServiceConfig;
import ru.yandex.passport.address.ServiceConfigBuilder;

public class AddressServicesRights {
    public static final AddressServicesRights INSTANCE = new AddressServicesRights();

    private final Map<String, AddressService> servicesTvmMap;
    private final Map<AddressService, Map<AddressService, ReadWriteRights>> allows;
    // set of services with enabled hide (they can mark other services addresses hidden)
    private final Set<AddressService> hiddenEnabled;
    private final Map<AddressService, ServiceConfig> serviceConfigs;

    private static void applyRight(
        final Map<AddressService, Map<AddressService, ReadWriteRights>> map,
        final AddressService clientService,
        final ReadWriteRights rights,
        final AddressService... ownerService)
    {
        for (AddressService service: ownerService) {
            map.computeIfAbsent(clientService, (k) -> new LinkedHashMap<>()).put(service, rights);
        }
    }

    private AddressServicesRights() {
        Map<String, AddressService> tvmMap = new LinkedHashMap<>();
//        tvmMap.put("2029754", "passport");
//        tvmMap.put("2029756", "passport");
//        tvmMap.put("2024739", "pay");
//        tvmMap.put("2026290", "pay");
//        tvmMap.put("2024741", "pay");
//        tvmMap.put("2014132", "taxi");
//        tvmMap.put("2014130", "taxi");

        tvmMap.put("2029754", AddressService.PASSPORT);
        tvmMap.put("2029756", AddressService.PASSPORT);
        // https://st.yandex-team.ru/PASSP-34637 passport testin and prod
        tvmMap.put("2010644", AddressService.PASSPORT);
        tvmMap.put("2010646", AddressService.PASSPORT);
        //https://st.yandex-team.ru/PS-3864
        tvmMap.put("2021181", AddressService.PASSPORT);
        tvmMap.put("2021183", AddressService.PASSPORT);

        tvmMap.put("2024739", AddressService.PAY);
        tvmMap.put("2026290", AddressService.PAY);
        tvmMap.put("2024741", AddressService.PAY);
        tvmMap.put("2029082", AddressService.PAY);
        tvmMap.put("2033545", AddressService.PAY);
        tvmMap.put("2029170", AddressService.PAY);

        tvmMap.put("2014132", AddressService.TAXI);
        tvmMap.put("2014130", AddressService.TAXI);


        tvmMap.put("2002414", AddressService.USLUGI);
        tvmMap.put("2002420", AddressService.USLUGI);


        tvmMap.put("2011664", AddressService.EDA);
        tvmMap.put("2019271", AddressService.EDA);
        tvmMap.put("2011662", AddressService.EDA);
        tvmMap.put("2019275", AddressService.EDA);

        tvmMap.put("2033365", AddressService.MARKET);
        tvmMap.put("2033367", AddressService.MARKET);

        tvmMap.put("2020751", AddressService.TOOLS_TRIP);
        tvmMap.put("2020755", AddressService.TOOLS_TRIP);
        servicesTvmMap = Collections.unmodifiableMap(tvmMap);

        Map<AddressService, Map<AddressService, ReadWriteRights>> map = new LinkedHashMap<>();
//        applyRight(map, "passport", ReadWriteRights.READ_WRITE, "passport", "pay", "market");
//        applyRight(map, "pay", ReadWriteRights.READ_WRITE,  "pay");
//        applyRight(map, "pay", ReadWriteRights.READ_ONLY,  "market", "passport");
//        applyRight(map, "taxi", ReadWriteRights.READ_WRITE,  "taxi");
        applyRight(
            map,
            AddressService.PASSPORT,
            ReadWriteRights.READ_WRITE,
            AddressService.PASSPORT,
            AddressService.PAY,
            AddressService.MARKET,
            AddressService.TAXI,
            AddressService.MAPS,
            AddressService.PASSPORT_DELIVERY);

        applyRight(map, AddressService.PAY, ReadWriteRights.READ_WRITE,  AddressService.PAY);
        applyRight(
            map,
            AddressService.PAY,
            ReadWriteRights.READ_ONLY,
            //AddressService.PASSPORT_DELIVERY,
            AddressService.MARKET,
            AddressService.MAPS,
            AddressService.PASSPORT);
        applyRight(map, AddressService.TAXI, ReadWriteRights.READ_WRITE,  AddressService.TAXI);
        //EDA
        applyRight(map, AddressService.EDA, ReadWriteRights.READ_WRITE,  AddressService.EDA);
        applyRight(
            map,
            AddressService.EDA,
            ReadWriteRights.READ_ONLY,
            //AddressService.PASSPORT_DELIVERY,
            AddressService.MARKET,
            AddressService.MAPS,
            AddressService.PASSPORT);

        //USLUGI
        applyRight(map, AddressService.USLUGI, ReadWriteRights.READ_WRITE,  AddressService.USLUGI);
        applyRight(
            map,
            AddressService.USLUGI,
            ReadWriteRights.READ_ONLY,
            //AddressService.PASSPORT_DELIVERY,
            AddressService.MARKET,
            AddressService.MAPS,
            AddressService.PASSPORT);

        //MARKET
        applyRight(map, AddressService.MARKET, ReadWriteRights.READ_WRITE,  AddressService.MARKET);
        applyRight(
            map,
            AddressService.MARKET,
            ReadWriteRights.READ_ONLY,
            //AddressService.PASSPORT_DELIVERY,
            AddressService.MAPS,
            AddressService.PASSPORT);

        // TOOLS_TRIP
        applyRight(map, AddressService.TOOLS_TRIP, ReadWriteRights.READ_WRITE, AddressService.TOOLS_TRIP);

        allows = Collections.unmodifiableMap(map);
        hiddenEnabled = Collections.singleton(AddressService.PAY);

        Map<AddressService, ServiceConfig> serviceConfigs = new LinkedHashMap<>();
        serviceConfigs.put(
            AddressService.EDA,
            new ServiceConfigBuilder().serviceKeepHisId(true).useGeocoderOnUpdate(false));
        serviceConfigs.put(
            AddressService.TAXI,
            new ServiceConfigBuilder().serviceKeepHisId(true).useGeocoderOnUpdate(false));
        this.serviceConfigs = Collections.unmodifiableMap(serviceConfigs);
    }

    public ServiceConfig serviceConfig(final AddressService service) {
        return serviceConfigs.getOrDefault(service, ServiceConfigDefault.INSTANCE);
    }

    public Map<String, AddressService> servicesTvmMap() {
        return servicesTvmMap;
    }

    public Map<AddressService, Map<AddressService, ReadWriteRights>> allows() {
        return allows;
    }

    public boolean hiddenEnabled(final AddressService service) {
        return hiddenEnabled.contains(service);
    }
}
