package ru.yandex.passport.address.config;

import ru.yandex.client.pg.config.ImmutablePgClientConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.config.ImmutableURIConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.msal.pool.ImmutableAddressPgConfig;

public class ImmutableAddressProxyConfig
    extends ImmutableHttpProxyConfig
    implements AddressProxyConfig
{
    private final ImmutableAddressPgConfig marketDbConfig;
    private final ImmutableAddressPgConfig passportDbConfig;
    private final ImmutablePgClientConfig passportPgClientConfig;
    private final ImmutableURIConfig geocoderConfig;
    private final ImmutableHttpHostConfig blackboxConfig;
    private final ImmutableHttpHostConfig deliveryDatasyncConfig;
    private final ImmutableHttpHostConfig homeWorkDatasyncConfig;
    private final ImmutableRegionBaseConfig regionBaseConfig;

    public ImmutableAddressProxyConfig(
        final AddressProxyConfig config)
        throws ConfigException
    {
        super(config);
        this.marketDbConfig =
            new ImmutableAddressPgConfig(
                config.marketDbConfig());
        this.passportDbConfig =
            new ImmutableAddressPgConfig(
                config.passportDbConfig());
        this.passportPgClientConfig =
            new ImmutablePgClientConfig(
                config.passportPgClientConfig());
        this.geocoderConfig =
            new ImmutableURIConfig(
                config.geocoderConfig());
        this.blackboxConfig = new ImmutableHttpHostConfig(config.blackboxConfig());
        this.deliveryDatasyncConfig = new ImmutableHttpHostConfig(config.deliveryDatasyncConfig());
        this.homeWorkDatasyncConfig = new ImmutableHttpHostConfig(config.homeWorkDatasyncConfig());
        this.regionBaseConfig
            = new ImmutableRegionBaseConfig(config.regionBaseConfig());
    }

    @Override
    public ImmutableAddressPgConfig marketDbConfig() {
        return marketDbConfig;
    }

    @Override
    public ImmutableAddressPgConfig passportDbConfig() {
        return passportDbConfig;
    }

    @Override
    public ImmutablePgClientConfig passportPgClientConfig() {
        return passportPgClientConfig;
    }

    @Override
    public ImmutableURIConfig geocoderConfig() {
        return geocoderConfig;
    }

    @Override
    public ImmutableHttpHostConfig blackboxConfig() {
        return blackboxConfig;
    }

    @Override
    public ImmutableHttpHostConfig homeWorkDatasyncConfig() {
        return homeWorkDatasyncConfig;
    }

    @Override
    public ImmutableHttpHostConfig deliveryDatasyncConfig() {
        return deliveryDatasyncConfig;
    }

    @Override
    public ImmutableRegionBaseConfig regionBaseConfig() {
        return regionBaseConfig;
    }
}
