package ru.yandex.passport.address.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class RegionBaseConfigBuilder
     extends AbstractRegionBaseConfigBuilder<RegionBaseConfigBuilder>
{
    public RegionBaseConfigBuilder() {
        this(RegionBaseConfigDefaults.INSTANCE);
    }

    public RegionBaseConfigBuilder(final RegionBaseConfig config) {
        super(config);
    }

    public RegionBaseConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, RegionBaseConfigDefaults.INSTANCE);
    }

    public RegionBaseConfigBuilder(
        final IniConfig config,
        final RegionBaseConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableRegionBaseConfig build() throws ConfigException {
        return new ImmutableRegionBaseConfig(
            this);
    }

    @Override
    public RegionBaseConfigBuilder self() {
        return this;
    }
}
