package ru.yandex.passport.address.filters;

import org.apache.commons.lang.StringUtils;

import ru.yandex.passport.address.Address;
import ru.yandex.passport.address.AddressFilter;

public enum YandexPayAddressFilter implements AddressFilter {
    INSTANCE;

    @Override
    public boolean test(final Address address) {
        return StringUtils.isNotBlank(address.country())
                   && StringUtils.isNotBlank(address.city())
                   && (StringUtils.isNotBlank(address.street()) || StringUtils.isNotBlank(address.district()))
                   && StringUtils.isNotBlank(address.building());
    }
}
