package ru.yandex.passport.address.handlers;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.passport.AddressContext;
import ru.yandex.passport.address.AbstractHandler;
import ru.yandex.passport.address.AddressId;
import ru.yandex.passport.address.AddressIdParser;

public abstract class AbstractAddressHandler
    extends AbstractHandler
{
    public static final Map<String, String> MARKET_COLUMNS_MAP;
    public static final Map<String, String> PASSPORT_COLUMNS_MAP;
    public static final String MARKET_COLUMNS_STMT;
    public static final String PASSPORT_COLUMNS_STMT;

    static {
        Map<String, String> columns = new LinkedHashMap<>();
        columns.put("address_id", "a.id");
        columns.put("region_id", "a.region_id");
        columns.put("precise_region_id", "a.precise_region_id");
        columns.put("country", "a.country");
        columns.put("city", "a.city");
        //columns.put("metro", "a.metro");
        columns.put("street", "a.street");
        columns.put("object_key", "a.object_key");
        columns.put("building", "a.building");
        columns.put("floor", "a.floor");
        columns.put("room", "a.room");
        columns.put("entrance", "a.entrance");
        columns.put("intercom", "a.intercom");
        columns.put("zip", "a.zip");
        columns.put("comment", "a.comment");
        columns.put("latitude", "a.latitude");
        columns.put("longitude", "a.longitude");
        columns.put("geocoder_status", "a.geocoder_status");
        columns.put("district", "a.district");
        columns.put("last_touched_time", "a.last_touched_time");
        columns.put("platform", "a.platform");
        columns.put("fullness_state", "a.fullness_state");
        MARKET_COLUMNS_MAP = Collections.unmodifiableMap(columns);
        MARKET_COLUMNS_STMT = buildStmt(MARKET_COLUMNS_MAP);

        columns.put("owner_service", "a.owner_service");
        columns.put("subtype", "a.subtype");
        columns.put("locale", "a.locale");
        columns.put("version", "a.version");
        columns.put("format_version", "a.format_version");
        columns.put("name", "a.name");
        columns.put("uri", "a.uri");
        columns.put("label", "a.label");
        columns.put("brand_name", "a.brand_name");
        columns.put("phone_id", "a.phone_id");
        columns.put("geocoder_name", "a.geocoder_name");
        columns.put("geocoder_description", "a.geocoder_description");
        columns.put("geocoder_object_type", "a.geocoder_object_type");
        columns.put("geocoder_exact", "a.geocoder_exact");
        columns.put("comment_courier", "a.comment_courier");
        columns.put("org_id", "a.org_id");
        columns.put("draft", "a.draft");
        columns.put("modification_time", "a.modification_time");
        columns.put("creation_time", "a.creation_time");

        PASSPORT_COLUMNS_MAP = Collections.unmodifiableMap(columns);
        PASSPORT_COLUMNS_STMT = buildStmt(PASSPORT_COLUMNS_MAP);
    }


    protected AddressId parseWithTaxi(final AddressContext context) throws IOException, BadRequestException {
        return parseWithTaxi(context, context.session().params().get("id", NonEmptyValidator.TRIMMED));
    }

    protected AddressId parseWithTaxi(final AddressContext context, final String idStr) throws IOException, BadRequestException {
        AddressId id;
        if (context.serviceConfig().serviceKeepHisId()) {
            if (idStr.indexOf('-') > 0) {
                try {
                    id = AddressIdParser.INSTANCE.parse(idStr);
                } catch (Exception e) {
                    throw new BadRequestException("Invalid id " + idStr, e);
                }
            } else {
                if ("home".equalsIgnoreCase(idStr) || "work".equalsIgnoreCase(idStr)) {
                    id = new AddressId(context.userType(), context.userId(), context.service(), context.userType() + "-" + context.userId() + "-" + idStr, true);
                } else {
                    id = new AddressId(context.userType(), context.userId(), context.service(), idStr, true);
                }
            }
        } else {
            try {
                id = AddressIdParser.INSTANCE.parse(idStr);
            } catch (Exception e) {
                throw new BadRequestException("Invalid id " + idStr, e);
            }
        }

        return id;
    }
}
