package ru.yandex.passport.address.handlers;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NByteArrayEntity;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.NByteArrayEntityFactory;
import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.passport.AbstractAddressSessionCallback;
import ru.yandex.passport.AddressContext;
import ru.yandex.passport.AddressProxy;
import ru.yandex.passport.AddressStorage;
import ru.yandex.passport.ReadWriteRights;
import ru.yandex.passport.address.AddressBuilder;
import ru.yandex.passport.address.AddressId;
import ru.yandex.passport.address.MarketAddressBuilder;
import ru.yandex.passport.address.PassportAddressBuilder;
import ru.yandex.passport.address.PassportAddressUser;

public class GetAddressHandler extends AbstractAddressHandler implements ProxyRequestHandler {
//    private final DBConnectionPool marketConnectionPool;
//    private final DBConnectionPool passportConnectionPool;
//
//    private static final String GET_MARKET_ADDRESS = "SELECT " + MARKET_COLUMNS_STMT +
//        " FROM address as a " +
//        "WHERE a.object_key=?";
//
//    private static final String GET_PASSPORT_ADDRESS = "SELECT " + PASSPORT_COLUMNS_STMT +
//        " FROM passport_address as a " +
//        "WHERE a.object_key=? AND a.locale=? " +
//        "AND NOT a.deleted AND NOT a.draft";

    private final AddressProxy proxy;

    public GetAddressHandler(final AddressProxy proxy) {
        //this.marketConnectionPool = proxy.pool(proxy.config().marketDbConfig());
        //this.passportConnectionPool = proxy.pool(proxy.config().passportDbConfig());
        this.proxy = proxy;
    }

    @Override
    public void handleInternal(final ProxySession session) throws HttpException, IOException, SQLException, JsonException {
        AddressContext context = new AddressContext(session);

        AddressId id = parseWithTaxi(context);
        //PassportAddressUser user = PassportAddressUser.parse(session.params());
        if (context.rights(id).ordinal() < ReadWriteRights.READ_ONLY.ordinal()) {
            writeErrorResponse(session, HttpStatus.SC_FORBIDDEN, "Service " + context.serviceName() + " does not have rights for namespace " + id.ownerService());
            return;
        }

        AddressStorage<AddressBuilder> storage = proxy.storage(id.ownerService());

        //AddressService service = AddressService.valueOf(id.ownerService().toLowerCase(Locale.ENGLISH));

        storage.get(context, id, new PrintGetCallback(context));
//        boolean market = MarketAddressBuilder.OWNER_SERVICE.equalsIgnoreCase(id.ownerService());
//        if (market) {
//            try (Connection connection = marketConnectionPool.getConnection(session.logger());
//                 PreparedStatement stmt = connection.prepareStatement(GET_MARKET_ADDRESS))
//            {
//                //stmt.setString(1, user.userType());
//                stmt.setString(1, id.addressId());
//                session.logger().info(stmt.toString());
//                try (ResultSet resultSet = stmt.executeQuery()) {
//                    writeResults(resultSet, user, context, market);
//                }
//            } catch (Exception e) {
//                session.logger().log(Level.SEVERE, "Request failed", e);
//                writeErrorResponse(session, HttpStatus.SC_INTERNAL_SERVER_ERROR, "Database request failure");
//                return;
//            }
//        } else {
//            try (Connection connection = passportConnectionPool.getConnection(session.logger());
//                 PreparedStatement stmt = connection.prepareStatement(GET_PASSPORT_ADDRESS))
//            {
//                String locale = session.params().getString("locale", "ru");
//                //stmt.setString(1, user.userType());
//                stmt.setString(1, id.addressId());
//                stmt.setString(2, locale);
//                session.logger().info(stmt.toString());
//                try (ResultSet resultSet = stmt.executeQuery()) {
//                    writeResults(resultSet, user, context, market);
//                }
//            } catch (Exception e) {
//                session.logger().log(Level.SEVERE, "Request failed", e);
//                writeErrorResponse(session, HttpStatus.SC_INTERNAL_SERVER_ERROR, "Database request failure");
//                return;
//            }
//        }
    }

    private class PrintGetCallback extends AbstractAddressSessionCallback<AddressBuilder> {
        private final AddressContext context;
        public PrintGetCallback(final AddressContext context) {
            super(context.session());

            this.context = context;
        }

        @Override
        public void completed(final AddressBuilder address) {
            ProxySession session = context.session();
            DecodableByteArrayOutputStream out =
                new DecodableByteArrayOutputStream();
            try (OutputStreamWriter outWriter = outWriter(session, out);
                 JsonWriter writer = context.jsonType().create(outWriter))
            {
                writer.startObject();
                writer.value(address);
                writer.key("status");
                writer.value("ok");
                writer.endObject();
            } catch (IOException | HttpException ioe) {
                failed(ioe);
                return;
            }

            NByteArrayEntity entity =
                out.processWith(NByteArrayEntityFactory.INSTANCE);
            entity.setContentType(
                ContentType.APPLICATION_JSON.withCharset(
                        session.acceptedCharset())
                    .toString());
            session.response(HttpStatus.SC_OK, entity);
        }
    }

    protected void writeResults(
        final ResultSet resultSet,
        final PassportAddressUser user,
        final AddressContext context,
        final boolean market)
        throws HttpException, IOException, SQLException
    {
        int status = HttpStatus.SC_OK;

        final ProxySession session = context.session();

        DecodableByteArrayOutputStream out =
            new DecodableByteArrayOutputStream();
        try (OutputStreamWriter outWriter = outWriter(session, out);
             JsonWriter writer = context.jsonType().create(outWriter))
        {
            writer.startObject();
            boolean next = resultSet.next();
            if (next) {
                AddressBuilder builder;
                if (market) {
                    builder = MarketAddressBuilder.build(user, resultSet);
                } else {
                    builder = PassportAddressBuilder.build(user, resultSet);
                    writer.value(user);
                }

                writer.value(builder);
                writer.key("status");
                writer.value("ok");
            } else {
                writer.key("status");
                writer.value("error");
                writer.key("error");
                writer.value("not found");
                status = HttpStatus.SC_NOT_FOUND;
            }
            writer.endObject();
        }

        NByteArrayEntity entity =
            out.processWith(NByteArrayEntityFactory.INSTANCE);
        entity.setContentType(
            ContentType.APPLICATION_JSON.withCharset(
                session.acceptedCharset())
                .toString());
        session.response(status, entity);
    }
}
