package ru.yandex.passport.contact;

import java.io.IOException;
import java.time.OffsetDateTime;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.passport.address.AddressId;
import ru.yandex.passport.address.AddressService;

public interface Contact extends JsonValue {
    AddressId id();

    AddressService ownerService();

    Object userId();

    String userType();

    String firstName();

    String lastName();

    String secondName();

    String phoneNum();

    String email();

    OffsetDateTime lastTouchedTime();

    OffsetDateTime creationTime();

    OffsetDateTime modificationTime();

    @Override
    default void writeValue(final JsonWriterBase writer) throws IOException {
        ContactDto.write(this, writer);
    }
}
