package ru.yandex.passport.contact;

import java.io.IOException;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.passport.AddressContext;

public class ContactDto {
    public static ContactBuilder parseForCreate(
        final AddressContext context,
        final JsonMap result)
        throws JsonException
    {
        ContactBuilder builder = new ContactBuilder();
        builder.ownerService(context.service());
        builder.firstName(result.getString("first_name"));
        builder.lastName(result.getString("last_name"));
        builder.secondName(result.getString("second_name", null));
        builder.email(result.getString("email"));
        String phoneNum = result.getString("phone_number");
        builder.phoneNum(ContactUtils.normalizePhoneNumber(context.session().logger(), phoneNum));
        builder.userId(context.userId());
        builder.userType(context.userType());
        return builder;
    }

    public static void write(
        final Contact contact,
        final JsonWriterBase writer)
        throws IOException
    {
        writer.key("id");
        writer.value(contact.id());
        writer.key("owner_service");
        writer.value(contact.ownerService().serviceName());
        writer.key("first_name");
        writer.value(contact.firstName());

        writer.key("second_name");
        writer.value(contact.secondName());

        writer.key("last_name");
        writer.value(contact.lastName());

        writer.key("email");
        writer.value(contact.email());

        writer.key("phone_number");
        writer.value(contact.phoneNum());

//        writer.key("creation_time");
//        writer.value(contact.creationTime());
    }
}
