package ru.yandex.passport.contact;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.logger.PrefixedLogger;

public class ContactUtils {
    private static final PhoneNumberUtil PHONE_UTIL = PhoneNumberUtil.getInstance();

    public static String normalizePhoneNumber(final PrefixedLogger logger, final String rawPhoneNumber) {
        return normalizePhoneNumber(logger, rawPhoneNumber, null);
    }

    public static String normalizePhoneNumber(
        final PrefixedLogger logger,
        final String rawNumber,
        final String fallbackPhoneNumber)
    {
        String rawPhoneNumber = rawNumber;
        if (StringUtils.isBlank(rawPhoneNumber)) {
            return fallbackPhoneNumber;
        }
        String unusualExtension = null;
        if (rawPhoneNumber.charAt(rawPhoneNumber.length() - 1) == ')') {
            //ситуация, когда дополнительный код написан в конце в скобках. Библиотекой libphonenumber не обрабатывается
            int openBracketPos = rawPhoneNumber.lastIndexOf('(');
            if (openBracketPos != -1) {
                unusualExtension = rawPhoneNumber.substring(openBracketPos + 1, rawPhoneNumber.length() - 1);
            }
            rawPhoneNumber = rawPhoneNumber.substring(0, openBracketPos - 1);
        }
        Phonenumber.PhoneNumber phoneNumber;
        try {
            phoneNumber = PHONE_UTIL.parse(rawPhoneNumber, "RU");
        } catch (NumberParseException e) {
            logger.warning("Can't normalize phone number \"" + rawPhoneNumber + "\"");
            return fallbackPhoneNumber;
        }
        if (unusualExtension != null) {
            phoneNumber.setExtension(unusualExtension);
        }
        String normalizedPhoneNumber = PHONE_UTIL.format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.E164);
        //Формат E164 даёт самое близкое к требованиям форматирование, но, к сожалению, не дописывает доп. номер
        if (phoneNumber.hasExtension()) {
            normalizedPhoneNumber += ("," + phoneNumber.getExtension());
        }
        return normalizedPhoneNumber;
    }
}
