package ru.yandex.passport.contact.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import ru.yandex.blackbox.BlackboxDbfield;
import ru.yandex.passport.address.AbstractHandler;

public abstract class AbstractContactHandler extends AbstractHandler {
    public static final Map<String, String> PSSPORT_SELECT_COLUMNS_MAP;
    public static final String PSSPORT_SELECT_COLUMNS_STMT;
    public static final Set<BlackboxDbfield> BLACKBOX_FIELDS =
        Collections.unmodifiableSet(
            new LinkedHashSet<>(
                Arrays.asList(
                    BlackboxDbfield.FIRSTNAME,
                    BlackboxDbfield.LASTNAME)));

    static {
        Map<String, String> columns = new LinkedHashMap<>();
        columns.put("first_name", "c.first_name");
        columns.put("id", "c.id");
        columns.put("last_name", "c.last_name");
        columns.put("second_name", "c.second_name");
        columns.put("phone_number", "c.phone_number");
        columns.put("email", "c.email");
        columns.put("creation_time", "c.creation_time");
        columns.put("contact_id", "c.id");
        columns.put("modification_time", "c.modification_time");
        columns.put("owner_service", "c.owner_service");
        columns.put("last_touched_time", "c.last_touched_time");
        columns.put("object_key", "c.object_key");
        PSSPORT_SELECT_COLUMNS_MAP = Collections.unmodifiableMap(new LinkedHashMap<>(columns));
        PSSPORT_SELECT_COLUMNS_STMT = buildStmt(PSSPORT_SELECT_COLUMNS_MAP);
    }
}
