package ru.yandex.passport.contact.handlers;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.Tuple;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NByteArrayEntity;

import ru.yandex.client.pg.SqlQuery;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.nio.NByteArrayEntityFactory;
import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.passport.AbstractAddressSessionCallback;
import ru.yandex.passport.AddressContext;
import ru.yandex.passport.AddressProxy;
import ru.yandex.passport.address.AddressId;
import ru.yandex.passport.contact.ContactBuilder;
import ru.yandex.passport.contact.ContactDto;

public class CreateContactHandler extends AbstractContactHandler {
    public static final List<String> CREATE_COLUMNS;
    private static final String INSERT_ADDRESS;
    private static final SqlQuery INSERT_ADDRESS_VERTX;

    static {
        CREATE_COLUMNS =
            Arrays.asList(
                "user_type",
                "user_id",
                "owner_service",
                "first_name",
                "last_name",
                "second_name",
                "phone_number",
                "email",
                "object_key");
        StringBuilder insert = new StringBuilder();
        StringBuilder insertVertx = new StringBuilder();
        insert.append("INSERT INTO passport_contact(");
        insertVertx.append("INSERT INTO passport_contact(");
        for (String column : CREATE_COLUMNS) {
            insert.append(column);
            insert.append(", ");
            insertVertx.append(column);
            insertVertx.append(", ");
        }

        insert.setLength(insert.length() - 2);
        insert.append(") VALUES (");
        insertVertx.setLength(insertVertx.length() - 2);
        insertVertx.append(") VALUES (");
        for (int i = 0; i < CREATE_COLUMNS.size(); i++) {
            insert.append("?, ");
            insertVertx.append("$");
            insertVertx.append(i+1);
            insertVertx.append(", ");
        }
        insert.setLength(insert.length() - 2);
        insert.append(") RETURNING id");
        insertVertx.setLength(insertVertx.length() - 2);
        insertVertx.append(") RETURNING id");
        INSERT_ADDRESS = insert.toString();
        INSERT_ADDRESS_VERTX = new SqlQuery("insert_contact", insertVertx.toString());
    }

    private final AddressProxy proxy;

    public CreateContactHandler(final AddressProxy proxy) {
        this.proxy = proxy;
        System.err.println(INSERT_ADDRESS);
        System.err.println("Vertx " + INSERT_ADDRESS_VERTX.query());
    }

    @Override
    public void handleInternal(
        final ProxySession session)
        throws HttpException, IOException, SQLException, JsonException
    {
        final AddressContext context = new AddressContext(session);
        if (!(session.request() instanceof HttpEntityEnclosingRequest)) {
            writeErrorResponse(session, HttpStatus.SC_BAD_REQUEST, "No body supplied for request");
            return;
        }

        JsonMap contactDto =
            TypesafeValueContentHandler.parse(
                CharsetUtils.content(
                    ((HttpEntityEnclosingRequest) session.request()).getEntity())).asMap();
        ContactBuilder contact = ContactDto.parseForCreate(context, contactDto);
        AddressId addressId = new AddressId(context.userType(), context.userId(), context.service());
        contact.id(addressId);

        context.session().logger().info("Contact before create " + contact);

        Tuple stmt = Tuple.tuple();
            stmt.addString(context.userType());
            stmt.addString(String.valueOf(context.userId()));
            stmt.addString(contact.ownerService().serviceName());
            stmt.addString(contact.firstName());
            stmt.addString(contact.lastName());
            stmt.addString(contact.secondName());
            stmt.addString(contact.phoneNum());
            stmt.addString(contact.email());
            stmt.addString(contact.id().addressId());

        proxy.pgClient().executeOnMaster(
            INSERT_ADDRESS_VERTX,
            stmt,
            new InsertCallback(contact, context, addressId));
//        try (Connection connection = passportConnectionPool.getConnection(
//            context.session().logger());
//             PreparedStatement stmt = connection.prepareStatement(INSERT_ADDRESS))
//        {
//            stmt.setString(1, context.userType());
//            stmt.setLong(2, context.userIdLong());
//            stmt.setString(3, contact.ownerService().serviceName());
//            stmt.setString(4, contact.firstName());
//            stmt.setString(5, contact.lastName());
//            stmt.setString(6, contact.secondName());
//            stmt.setString(7, contact.phoneNum());
//            stmt.setString(8, contact.email());
//            stmt.setString(9, contact.id().addressId());
//
//            context.session().logger().info(stmt.toString());
//            try (ResultSet resultSet = stmt.executeQuery()) {
//                if (!resultSet.next()) {
//                    writeErrorResponse(session, HttpStatus.SC_INTERNAL_SERVER_ERROR, "Insert returned empty response");
//                    return;
//                }
//                Long id = resultSet.getLong("id");
//                context.session().logger().info("Saved " + id);
//
//
//                contact.id(addressId);
//                DecodableByteArrayOutputStream out =
//                    new DecodableByteArrayOutputStream();
//                try (OutputStreamWriter outWriter = outWriter(session, out);
//                     JsonWriter writer = context.jsonType().create(outWriter))
//                {
//                    writer.startObject();
//                    writer.key("status");
//                    writer.value("ok");
//                    writer.value(contact);
//                    writer.endObject();
//                }
//
//                NByteArrayEntity entity =
//                    out.processWith(NByteArrayEntityFactory.INSTANCE);
//                entity.setContentType(
//                    ContentType.APPLICATION_JSON.withCharset(
//                            session.acceptedCharset())
//                        .toString());
//                session.response(HttpStatus.SC_OK, entity);
//            }
//        }
    }

    private class InsertCallback extends AbstractAddressSessionCallback<RowSet<Row>> {
        private final ContactBuilder contact;
        private final AddressContext context;
        private final AddressId addressId;

        public InsertCallback(final ContactBuilder contact, final AddressContext context, final AddressId id) {
            super(context.session());
            this.contact = contact;
            this.context = context;
            this.addressId = id;
        }

        @Override
        public void completed(final RowSet<Row> rows) {
            ProxySession session = session();
            try {
                if (rows.rowCount() <= 0) {
                    writeErrorResponse(session, HttpStatus.SC_INTERNAL_SERVER_ERROR, "Insert returned empty response");
                    return;
                }

                Row resultSet = rows.iterator().next();
                Long id = resultSet.getLong("id");
                context.session().logger().info("Saved " + id);


                contact.id(addressId);
                DecodableByteArrayOutputStream out =
                    new DecodableByteArrayOutputStream();
                try (OutputStreamWriter outWriter = outWriter(session, out);
                     JsonWriter writer = context.jsonType().create(outWriter)) {
                    writer.startObject();
                    writer.key("status");
                    writer.value("ok");
                    writer.value(contact);
                    writer.endObject();
                }

                NByteArrayEntity entity =
                    out.processWith(NByteArrayEntityFactory.INSTANCE);
                entity.setContentType(
                    ContentType.APPLICATION_JSON.withCharset(
                            session.acceptedCharset())
                        .toString());
                session.response(HttpStatus.SC_OK, entity);
            } catch (HttpException | IOException ioe) {
                failed(ioe);
            }
        }
    }
}
