package ru.yandex.passport.contact.handlers;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NByteArrayEntity;

import ru.yandex.blackbox.BlackboxClient;
import ru.yandex.blackbox.BlackboxEmailsType;
import ru.yandex.blackbox.BlackboxPhoneAttributeType;
import ru.yandex.blackbox.BlackboxUserIdType;
import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.blackbox.BlackboxUserinfoRequest;
import ru.yandex.blackbox.BlackboxUserinfos;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.NotFoundException;
import ru.yandex.http.util.nio.NByteArrayEntityFactory;
import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.passport.AbstractAddressSessionCallback;
import ru.yandex.passport.AddressContext;
import ru.yandex.passport.AddressProxy;
import ru.yandex.passport.address.AddressId;
import ru.yandex.passport.address.AddressIdParser;
import ru.yandex.passport.address.AddressService;
import ru.yandex.passport.contact.Contact;
import ru.yandex.passport.contact.ContactBuilder;
import ru.yandex.search.msal.pool.DBConnectionPool;

public class GetContactHandler extends AbstractContactHandler implements ProxyRequestHandler {
    //private final DBConnectionPool marketConnectionPool;
    private final DBConnectionPool passportConnectionPool;

    private static final String PASSPORT_LIST_CONTACTS =
        "SELECT " + PSSPORT_SELECT_COLUMNS_STMT +
            " FROM passport_contact as c " +
            "WHERE c.object_key = ? AND NOT deleted";

    private final AddressProxy proxy;
    public GetContactHandler(final AddressProxy proxy) {
        //this.marketConnectionPool = proxy.pool(proxy.config().marketDbConfig());
        this.passportConnectionPool = proxy.pool(proxy.config().passportDbConfig());
        this.proxy = proxy;
    }

    @Override
    public void handleInternal(final ProxySession session)
        throws HttpException, IOException, SQLException, JsonException
    {
        AddressId id = session.params().get("id", AddressIdParser.INSTANCE);
        AddressContext context = new AddressContext(session);
        if (id.ownerService() == AddressService.PASSPORT && id.addressId().startsWith("blackbox")) {
            Integer bid = ContactBuilder.parseBlackboxId(id.addressId());
            if (bid == null) {
                session.response(HttpStatus.SC_NOT_FOUND);
                return;
            }
            BlackboxClient blackboxClient = proxy.blackboxClient().adjust(session.context());
            BlackboxUserinfoRequest request =
                new BlackboxUserinfoRequest(BlackboxUserIdType.UID, context.userId())
                    .dbfields(BLACKBOX_FIELDS)
                    .emailsType(BlackboxEmailsType.GETDEFAULT)
                    .phoneAttributes(BlackboxPhoneAttributeType.PHONE_NUMBER);

            blackboxClient.userinfo(request, session.listener()
                    .createContextGeneratorFor(blackboxClient),
                new BlackboxCallback(context, bid));
            return;
        }
        //int offset = session.params().getInt("offset", 0);
        try (Connection connection = passportConnectionPool.getConnection(session.logger());
             PreparedStatement stmt = connection.prepareStatement(PASSPORT_LIST_CONTACTS)) {
            session.logger().info(stmt.toString());
            //session.logger().info(PASSPORT_LIST_CONTACTS);
            //stmt.setString(1, user.userType());
            stmt.setString(1, id.addressId());

            try (ResultSet resultSet = stmt.executeQuery()) {
                writeResults(resultSet, context);
            }
        }
    }

    protected void writeResults(
        final ResultSet resultSet,
        final AddressContext context)
        throws HttpException, IOException, SQLException {
        int status = HttpStatus.SC_OK;

        final ProxySession session = context.session();

        DecodableByteArrayOutputStream out =
            new DecodableByteArrayOutputStream();
        try (OutputStreamWriter outWriter = outWriter(session, out);
             JsonWriter writer = context.jsonType().create(outWriter)) {
            writer.startObject();
            boolean next = resultSet.next();
            if (next) {
                ContactBuilder contact = ContactBuilder.build(context.userId(), context.userType(), resultSet);
                writer.value(contact);

                writer.key("status");
                writer.value("ok");
            } else {
                writer.key("status");
                writer.value("error");
                writer.key("error");
                writer.value("not found");
                status = HttpStatus.SC_NOT_FOUND;
            }
            writer.endObject();
        }

        NByteArrayEntity entity =
            out.processWith(NByteArrayEntityFactory.INSTANCE);
        entity.setContentType(
            ContentType.APPLICATION_JSON.withCharset(
                    session.acceptedCharset())
                .toString());
        session.response(status, entity);
    }

    private class BlackboxCallback extends AbstractAddressSessionCallback<BlackboxUserinfos> {
        private final AddressContext context;
        private final int id;

        public BlackboxCallback(final AddressContext context, final int id) {
            super(context.session());
            this.context = context;
            this.id = id;
        }

        @Override
        public void completed(final BlackboxUserinfos userinfos) {
            //List<Contact> contacts = new ArrayList<>(length);
            // id statarts from 1
            if (id > userinfos.size()) {
                failed(new NotFoundException("Contact was not found"));
                return;
            }
            BlackboxUserinfo userinfo = userinfos.get(id - 1);
            Contact contact = ContactBuilder.fromBlackboxUserInfo(
                context.session().logger(),
                context.userId(),
                context.userType(),
                userinfo,
                String.valueOf(id));

            DecodableByteArrayOutputStream out =
                new DecodableByteArrayOutputStream();
            try (OutputStreamWriter outWriter = outWriter(context.session(), out);
                 JsonWriter writer = context.jsonType().create(outWriter)) {
                writer.startObject();
                writer.value(contact);

                writer.key("status");
                writer.value("ok");
                writer.endObject();
            } catch (IOException | HttpException ioe) {
                failed(ioe);
                return;
            }

            NByteArrayEntity entity =
                out.processWith(NByteArrayEntityFactory.INSTANCE);
            entity.setContentType(
                ContentType.APPLICATION_JSON.withCharset(
                        context.session().acceptedCharset())
                    .toString());
            session().response(HttpStatus.SC_OK, entity);
        }
    }
}
