package ru.yandex.passport.contact.handlers;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.Tuple;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NByteArrayEntity;

import ru.yandex.client.pg.SqlQuery;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.nio.NByteArrayEntityFactory;
import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.passport.AbstractAddressSessionCallback;
import ru.yandex.passport.AddressContext;
import ru.yandex.passport.AddressProxy;
import ru.yandex.passport.ReadWriteRights;
import ru.yandex.passport.address.AddressId;
import ru.yandex.passport.address.AddressIdParser;
import ru.yandex.passport.contact.ContactBuilder;
import ru.yandex.passport.contact.ContactDto;

public class UpdateContactHandler extends AbstractContactHandler {
    private static final List<String> UPDATE_COLUMNS;
    private static final String UPDATE_CONTACT;
    private static final SqlQuery UPDATE_CONTACT_VERTX;

    static {
        UPDATE_COLUMNS =
            Arrays.asList(
                "user_type",
                "user_id",
                "first_name",
                "last_name",
                "second_name",
                "phone_number",
                "email");
        StringBuilder update = new StringBuilder();
        StringBuilder updateVertx = new StringBuilder();
        update.append("UPDATE passport_contact SET ");
        updateVertx.append("UPDATE passport_contact SET ");
        int i = 1;
        for (String column : UPDATE_COLUMNS) {
            update.append(column);
            update.append(" = ?, ");
            updateVertx.append(column);
            updateVertx.append(" = $");
            updateVertx.append(i++);
            updateVertx.append(", ");
        }

        update.setLength(update.length() - 2);
        update.append(" WHERE object_key = ? RETURNING id");
        updateVertx.setLength(updateVertx.length() - 2);
        updateVertx.append(" WHERE object_key = $" + i + " RETURNING id");
        UPDATE_CONTACT = update.toString();
        UPDATE_CONTACT_VERTX = new SqlQuery("update_contact", updateVertx.toString());
    }

    //private final DBConnectionPool passportConnectionPool;
    private final AddressProxy proxy;

    public UpdateContactHandler(final AddressProxy proxy) {
        //this.marketConnectionPool = proxy.pool(proxy.config().marketDbConfig());
        //this.passportConnectionPool = proxy.pool(proxy.config().passportDbConfig());
        this.proxy = proxy;
        System.out.println(UPDATE_CONTACT);
        System.out.println(UPDATE_CONTACT_VERTX.query());
    }


    @Override
    public void handleInternal(ProxySession session) throws HttpException, IOException, SQLException, JsonException {
        final AddressContext context = new AddressContext(session);
        if (!(session.request() instanceof HttpEntityEnclosingRequest)) {
            writeErrorResponse(session, HttpStatus.SC_BAD_REQUEST, "No body supplied for request");
            return;
        }

        JsonMap contactDto =
            TypesafeValueContentHandler.parse(
                CharsetUtils.content(
                    ((HttpEntityEnclosingRequest) session.request()).getEntity())).asMap();
        ContactBuilder contact = ContactDto.parseForCreate(context, contactDto);
        AddressId id = context.session().params().get("id", null, AddressIdParser.INSTANCE);
        if (id == null) {
            id = contactDto.get("id", AddressIdParser.INSTANCE);
        }
        contact.id(id);

        //PassportAddressUser user = PassportAddressUser.parse(session.params());
        if (context.rights(id).ordinal() < ReadWriteRights.READ_WRITE.ordinal()) {
            writeErrorResponse(
                session,
                HttpStatus.SC_FORBIDDEN,
                "Service " + context.serviceName()
                    + " does not have write rights for namespace " + id.ownerService());
            return;
        }

        context.session().logger().info("Contact before update " + contact);

        Tuple stmt = Tuple.tuple();
        stmt.addString(context.userType());
        stmt.addString(String.valueOf(context.userId()));
        stmt.addString(contact.firstName());
        stmt.addString(contact.lastName());
        stmt.addString(contact.secondName());
        stmt.addString(contact.phoneNum());
        stmt.addString(contact.email());
        stmt.addString(id.addressId());

        proxy.pgClient().executeOnMaster(
            UPDATE_CONTACT_VERTX,
            stmt,
            new UpdateCallback(contact, context));
    }

    private class UpdateCallback extends AbstractAddressSessionCallback<RowSet<Row>> {
        private final ContactBuilder contact;
        private final AddressContext context;

        public UpdateCallback(final ContactBuilder contact, final AddressContext context) {
            super(context.session());
            this.contact = contact;
            this.context = context;
        }

        @Override
        public void completed(final RowSet<Row> rows) {
            ProxySession session = session();
            try {
                if (rows.rowCount() <= 0) {
                    writeErrorResponse(session, HttpStatus.SC_INTERNAL_SERVER_ERROR, "Insert returned empty response");
                    return;
                }

                Row resultSet = rows.iterator().next();
                Long contactId = resultSet.getLong("id");
                context.session().logger().info("Saved " + contactId);
                DecodableByteArrayOutputStream out =
                    new DecodableByteArrayOutputStream();
                try (OutputStreamWriter outWriter = outWriter(session, out);
                     JsonWriter writer = context.jsonType().create(outWriter))
                {
                    writer.startObject();
                    writer.key("status");
                    writer.value("ok");
                    writer.value(contact);
                    writer.endObject();
                }

                NByteArrayEntity entity =
                    out.processWith(NByteArrayEntityFactory.INSTANCE);
                entity.setContentType(
                    ContentType.APPLICATION_JSON.withCharset(
                            session.acceptedCharset())
                        .toString());
                session.response(HttpStatus.SC_OK, entity);
            } catch (HttpException | IOException ioe) {
                failed(ioe);
            }
        }
    }
}
