JAVA_PROGRAM(address_proxy)

JDK_VERSION(11)

OWNER(g:personal-search)

INCLUDE(${ARCADIA_ROOT}/mail/persdata/build/stricter_java_check.inc)

#INCLUDE(${ARCADIA_ROOT}/library/java/dependency_management.inc)
#INCLUDE(${ARCADIA_ROOT}/market/contrib.ya.make)

#LINT(strict)
#
#CHECK_JAVA_DEPS(yes)
#
#USE_ERROR_PRONE()
#
#JAVAC_FLAGS(-Xlint)
#
#JAVAC_FLAGS(
#    -Xep:BadImport:ERROR
#    -Xep:CatchAndPrintStackTrace:ERROR
#    -Xep:ClassCanBeStatic:ERROR
#    -Xep:CollectionIncompatibleType:ERROR
#    -Xep:DefaultCharset:ERROR
#    -Xep:EqualsGetClass:ERROR
#    -Xep:HidingField:ERROR
#    -Xep:IdentityHashMapBoxing:ERROR
#    -Xep:JdkObsolete:ERROR
#    -Xep:LockNotBeforeTry:ERROR
#    -Xep:MissingFail:ERROR
#    -Xep:MissingOverride:ERROR
#    -Xep:NonOverridingEquals:ERROR
#    -Xep:ProtectedMembersInFinalClass:ERROR
#    -Xep:PublicConstructorForAbstractClass:ERROR
#    -Xep:ReferenceEquality:ERROR
#    -Xep:StreamResourceLeak:ERROR
#    -Xep:TypeParameterShadowing:ERROR
#    -Xep:UndefinedEquals:ERROR
#    -Xep:UnnecessaryParentheses:ERROR
#    -Xep:UnsynchronizedOverridesSynchronized:ERROR
#    -Xep:UnusedMethod:ERROR
#    -Xep:UnusedNestedClass:ERROR
#    -Xep:UnusedVariable:ERROR
#    -Xep:UseCorrectAssertInTests:ERROR
#)

JAVA_SRCS(SRCDIR main/java **/*.java)
#JAVA_SRCS(SRCDIR main/resources **/*)
DEPENDENCY_MANAGEMENT(
    contrib/java/org/apache/commons/commons-pool2/2.9.0
    contrib/java/org/postgresql/postgresql/42.2.6
    contrib/java/commons-io/commons-io/2.6
)
PEERDIR(
    mail/library/multistarter
    mail/library/http/ljinx
    mail/library/pg_client
    mail/search/mail/msal
    mail/search/mail/pg_lib
    mail/search/universal_search_proxy
    mail/search/passport/address/address_pg_backend
    mail/util/base64
    mail/library/blackbox
    mail/search/passport/passport_search
    #market/pers-address/pers-address-back
    contrib/java/com/googlecode/libphonenumber/libphonenumber/8.11.1
    contrib/java/org/jetbrains/annotations/20.1.0
    contrib/java/org/apache/commons/commons-lang3/3.9
    contrib/java/ru/yandex/common-util/8168277
)

EXCLUDE (
    contrib/java/com/sun/mail/javax.mail/1.6.0
    contrib/java/javax/activation/activation/1.1/activation-1.1.jar
    contrib/java/org/apache/httpcomponents/httpclient/4.5.6/httpclient-4.5.6.jar
    contrib/java/org/apache/httpcomponents/httpcore/4.4.10/httpcore-4.4.10.jar
    contrib/java/org/springframework/spring-jcl/5.1.6.RELEASE/spring-jcl-5.1.6.RELEASE.jar
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/mail/tools/templates/classpath.template.sh
    OUT ${BINDIR}/classpath.sh
    CUSTOM_PROPERTY packageName address_proxy
)

END()

IF (SANITIZER_TYPE != "memory" AND SANITIZER_TYPE != "undefined")
    RECURSE_FOR_TESTS(
        test
    )
ENDIF()



