#!/bin/bash
set -exo pipefail

source contact_proxy_config.sh
source classpath.sh

export LANG=en_US.UTF-8
export LD_LIBRARY_PATH=.

export PROXY_WORKERS=$((CPU_CORES / 2))
if [ "$PROXY_WORKERS" -lt 4 ]; then
    export PROXY_WORKERS=4
fi

export CPU_CORES=5

XMX=$(portoctl get self memory_limit_total)
XMX=$(echo $XMX | gawk '{print int($1 * 0.8 / 1048576)}')
XMS=$((XMX / 4))
CONTACT_PROXY_CONFIG="contact_proxy.conf"

MEM_ARGS="-Xms${XMS}M -Xmx${XMX}M  -Xmn384M -Xmaxf0.4 -Xminf0.2 -Xmine256M -Xmaxe1G -Xmint0.03"
GC_ARGS="-XX:ActiveProcessorCount=${CPU_CORES} -Xgcpolicy:balanced -verbose:gc -Xverbosegclog:/logs/gc#.log,10,10000"
DUMP_ARGS="-Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
exec $BSCONFIG_IDIR/jdk/bin/java \
    $MEM_ARGS $DUMP_ARGS $GC_ARGS $NET_ARGS \
    -Djava.library.path=contact \
    -cp $CLASSPATH \
    ru.yandex.passport.contact.ContactProxy $CONTACT_PROXY_CONFIG
