package ru.yandex.passport.contact;

import java.util.logging.Logger;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.parser.searchmap.User;
import ru.yandex.passport.contact.callback.fetcher.HasContactInContactsFetcher;
import ru.yandex.search.prefix.StringPrefix;
import ru.yandex.search.proxy.universal.UniversalSearchProxyRequestContext;

public class ContactContext implements UniversalSearchProxyRequestContext {
    private static final String MESSAGES_SERVICE = "messenger_messages";
    private static final String USERS_SERVICE = "messenger_users";

    private final ContactProxy proxy;
    private final ProxySession session;
    private User user;

    /**
     * Is used in {@link ru.yandex.passport.contact.callback.MutualConnectionsCallback} to put the owner's guid
     * to context and in {@link HasContactInContactsFetcher} as a request
     * parameter.
     */
    private String targetGuid;

    public ContactContext(ContactProxy proxy, ProxySession session) {
        this.proxy = proxy;
        this.session = session;
    }

    private ContactContext(ContactProxy proxy, ProxySession session, String targetGuid) {
        this(proxy, session);
        this.targetGuid = targetGuid;
    }

    private ContactContext(ContactContext context) {
        this(context.proxy(), context.session(), context.targetGuid);
    }

    private ContactContext(ContactContext context, String ownerGuid) {
        this(context.proxy(), context.session(), ownerGuid);
    }

    private ContactContext setUseInMessagesService(String prefix) {
        this.user = new User(MESSAGES_SERVICE, new StringPrefix(prefix));
        return this;
    }

    private ContactContext setUseInUsersService(String prefix) {
        this.user = new User(USERS_SERVICE, new StringPrefix(prefix));
        return this;
    }

    /**
     * @param puid id in messages service.
     * @return copy of the current context with user with puid.
    */
    public ContactContext inMessagesService(String puid) {
        session.logger().info("Changed service in context to " + MESSAGES_SERVICE + " and puid " + puid);
        return new ContactContext(this).setUseInMessagesService(puid);
    }

    /**
     * @param guid id in users service
     * @return copy of the current context with user with guid.
     */
    public ContactContext inUsersService(String guid) {
        session.logger().info("Changed service in context to " + USERS_SERVICE + " and guid " + guid);
        return new ContactContext(this).setUseInUsersService(guid);
    }

    public ContactContext targetGuid(String targetGuid) {
        return new ContactContext(proxy, session, targetGuid);
    }

    public String targetGuid() {
        return targetGuid;
    }

    @Override
    public User user() {
        return user;
    }

    @Override
    public Long minPos() {
        return null;
    }

    @Override
    public long lagTolerance() {
        return 0;
    }

    @Override
    public AbstractAsyncClient<?> client() {
        return proxy.searchClient().adjust(session.context());
    }

    @Override
    public Logger logger() {
        return session.logger();
    }

    public ContactProxy proxy() {
        return proxy;
    }

    public ProxySession session() {
        return session;
    }
}
