package ru.yandex.passport.contact;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

import ru.yandex.collection.Pattern;
import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;
import ru.yandex.search.proxy.universal.UniversalSearchProxy;
import ru.yandex.stater.IntegralSumAggregatorFactory;
import ru.yandex.stater.NamedStatsAggregatorFactory;
import ru.yandex.stater.PassiveStaterAdapter;

public class ContactProxy extends UniversalSearchProxy {
    private static final long MINUTES_EXPIRE = 10;
    private static final long MAX_SIZE = 500000;

    private final Cache<String, ContactResponse> contactCache;

    private final TimeFrameQueue<Long> contactCacheHit;

    public ContactProxy(ImmutableUniversalSearchProxyConfig config) throws IOException {
        super(config);
        contactCache = CacheBuilder.newBuilder()
                .expireAfterWrite(MINUTES_EXPIRE, TimeUnit.MINUTES)
                .maximumSize(MAX_SIZE)
                .concurrencyLevel(config().workers()).build();

        contactCacheHit = new TimeFrameQueue<>(config.metricsTimeFrame());

        registerStater(new PassiveStaterAdapter<>(
            contactCacheHit,
            new NamedStatsAggregatorFactory<>(
                "contact-cache-hit_ammm",
                IntegralSumAggregatorFactory.INSTANCE)));

        register(
                new Pattern<>("/contacts/plus/list/", false),
                new ListHandler(this));
    }

    public Cache<String, ContactResponse> contactCache() {
        return contactCache;
    }

    public TimeFrameQueue<Long> contactCacheHit() {
        return contactCacheHit;
    }
}
