package ru.yandex.passport.contact;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.passport.contact.utils.IntersectionResult;


public class ContactResponse implements JsonValue  {
    private static final String ID = "guid";
    private static final String NAME = "contact_name";
    private final Collection<IntersectionResult> contacts = new ArrayList<>();

    public ContactResponse(Collection<IntersectionResult> contacts) {
        this.contacts.addAll(contacts);
    }

    @Override
    public void writeValue(JsonWriterBase writer) throws IOException {
        writer.startArray();
        for (IntersectionResult contact: contacts) {
            writer.startObject();
            writer.key(ID);
            writer.value(contact.contactGuid());
            writer.key(NAME);
            writer.value(contact.contactName());
            writer.endObject();
        }
        writer.endArray();
    }

    public void writeSize(JsonWriterBase writer) throws IOException {
        writer.value(contacts.size());
    }
}
