package ru.yandex.passport.contact;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.passport.contact.callback.AggregatingCallback;
import ru.yandex.passport.contact.callback.ContactResultPrinter;
import ru.yandex.passport.contact.callback.MutualConnectionsCallback;
import ru.yandex.passport.contact.callback.fetcher.GuidsByPuidFetcher;
import ru.yandex.passport.contact.callback.utils.PutToCacheCallback;

public class ListHandler
        implements ProxyRequestHandler
{
    private static final String ID = "user_id";
    private static final String CLEAR_CACHE = "clear_cache";

    private final ContactProxy proxy;

    public ListHandler(ContactProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public void handle(ProxySession session) throws HttpException {
        CgiParams params = session.params();
        String puid = params.getString(ID);
        ContactContext context = new ContactContext(proxy, session);

        boolean clearCache = params.get(CLEAR_CACHE) != null; // TODO: remove
        if (clearCache) {
            proxy.contactCache().invalidateAll();
        }

        ContactResponse results = proxy.contactCache().getIfPresent(puid);
        if (results == null) {
            proxy.contactCacheHit().accept(0L);
            new GuidsByPuidFetcher(
                context,
                new MutualConnectionsCallback(
                    context,
                    new AggregatingCallback(
                        new PutToCacheCallback<>(
                            context,
                            puid,
                            proxy.contactCache(),
                            new ContactResultPrinter(session))))
            ).completed(puid);
        } else {
            proxy.contactCacheHit().accept(1L);
            new ContactResultPrinter(session).completed(results);
        }
    }
}
