package ru.yandex.passport.contact.callback;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.passport.contact.ContactResponse;
import ru.yandex.passport.contact.utils.IntersectionResult;

public class AggregatingCallback
    extends AbstractFilterFutureCallback<Collection<Optional<IntersectionResult>>, ContactResponse> {
    public AggregatingCallback(FutureCallback<? super ContactResponse> callback) {
        super(callback);
    }

    @Override
    public void completed(Collection<Optional<IntersectionResult>> response) {
        List<IntersectionResult> intersection = new ArrayList<>(response.size());
        for (Optional<IntersectionResult> res: response) {
            res.ifPresent(intersection::add);
        }
        callback.completed(new ContactResponse(intersection));
    }
}
