package ru.yandex.passport.contact.callback;

import java.util.Optional;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.passport.contact.utils.Contact;
import ru.yandex.passport.contact.utils.IntersectionResult;

public class IntersectionCallback
    extends AbstractFilterFutureCallback<Boolean, Optional<IntersectionResult>>
{
    private final Contact originalContact;

    public IntersectionCallback(
        Contact originalContact,
        FutureCallback<? super Optional<IntersectionResult>> callback)
    {
        super(callback);
        this.originalContact = originalContact;
    }

    /**
     * Composes the intersection result from the given parental (owner's) contact.
     * @param response flag, is true if connection between users is mutual, else false
     */
    @Override
    public void completed(Boolean response) {
        if (response) {
            callback.completed(
                Optional.of(
                    new IntersectionResult(originalContact.guid(), originalContact.contactName())));
        } else {
            callback.completed(Optional.empty());
        }
    }
}
