package ru.yandex.passport.contact.callback;

import java.util.Collection;
import java.util.Optional;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.passport.contact.ContactContext;
import ru.yandex.passport.contact.callback.fetcher.ContactsByGuidFetcher;
import ru.yandex.passport.contact.callback.utils.FlatCallback;
import ru.yandex.passport.contact.utils.IntersectionResult;

public class MutualConnectionsCallback
    extends AbstractFilterFutureCallback<Collection<String>, Collection<Optional<IntersectionResult>>>
{
    private final ContactContext context;
    public MutualConnectionsCallback(
        ContactContext context,
        FutureCallback<? super Collection<Optional<IntersectionResult>>> callback)
    {
        super(callback);
        this.context = context;
    }

    @Override
    public void completed(Collection<String> guids) {
        MultiFutureCallback<Collection<Optional<IntersectionResult>>> mfcb =
            new MultiFutureCallback<>(new FlatCallback<>(callback));
        context.session().logger().info(guids.size() + " guids.");
        for (String guid: guids) {
            var curCallback =
                new ContactsByGuidFetcher(
                    context,
                    new MutuallyConnectedCallback(context.targetGuid(guid), mfcb.newCallback())
                );
            curCallback.completed(guid);
        }
        mfcb.done();
    }
}
