package ru.yandex.passport.contact.callback;


import java.util.Collection;
import java.util.Optional;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.passport.contact.ContactContext;
import ru.yandex.passport.contact.callback.fetcher.HasContactInContactsFetcher;
import ru.yandex.passport.contact.utils.Contact;
import ru.yandex.passport.contact.utils.IntersectionResult;

/**
 * This class is used to determine for user A and all its contacts if the contact has user A in its contacts.
 */
public class MutuallyConnectedCallback
    extends AbstractFilterFutureCallback<Collection<Contact>, Collection<Optional<IntersectionResult>>> {
    private final ContactContext context;

    public MutuallyConnectedCallback(
        ContactContext context,
        FutureCallback<? super Collection<Optional<IntersectionResult>>> callback)
    {
        super(callback);
        this.context = context;
    }

    @Override
    public void completed(Collection<Contact> contacts) {
        MultiFutureCallback<Optional<IntersectionResult>> mfcb =
            new MultiFutureCallback<>(callback);
        context.session().logger().info("Looking for intersection for " + contacts.size() + " contacts.");
        for (Contact contact: contacts) {
            var curCallback =
                new HasContactInContactsFetcher(
                    context,
                    new IntersectionCallback(contact, mfcb.newCallback())
                );
            curCallback.completed(contact.guid());
        }
        mfcb.done();
    }
}
