package ru.yandex.passport.contact.callback.extractor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.passport.contact.utils.Contact;

public class ContactExtractor extends ExtractingCallback<Collection<Contact>> {
    private static final String ID_FIELD = "contact_id";
    private static final String NAME_FIELD = "contact_name";
    private static final String OWNER_FIELD = "contact_user_id";

    public ContactExtractor(FutureCallback<? super Collection<Contact>> callback) {
        super(callback);
    }

    @Override
    public void completed(JsonList response) {
        Set<Contact> contacts;
        try {
            contacts = new HashSet<>(response.size());
            for (JsonObject jsonContact: response) {
                JsonMap contact = jsonContact.asMap();
                contacts.add(
                        new Contact(
                                contact.get(ID_FIELD).asString(),
                                contact.get(NAME_FIELD).asString(),
                                contact.get(OWNER_FIELD).asString()));
            }
            callback.completed(contacts);
        } catch (JsonException e) {
            failed(e);
            callback.failed(e);
        }
    }
}
