package ru.yandex.passport.contact.callback.extractor;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;

public abstract class ExtractingCallback<T> extends AbstractFilterFutureCallback<JsonObject, T> {
    private static final String INNER_FIELD = "hitsArray";
    protected ExtractingCallback(FutureCallback<? super T> callback) {
        super(callback);
    }

    @Override
    public void completed(JsonObject response) {
        try {
            completed(response.asMap().get(INNER_FIELD).asList());
        } catch (JsonBadCastException e) {
            failed(e);
        }
    }

    protected abstract void completed(JsonList response);
}
