package ru.yandex.passport.contact.callback.extractor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class GuidExtractor extends ExtractingCallback<Collection<String>> {
    private static final String GUID_FIELD = "user_id";

    public GuidExtractor(FutureCallback<? super Collection<String>> callback) {
        super(callback);
    }

    @Override
    protected void completed(JsonList response) {
        Set<String> guids = new HashSet<>();
        try {
            guids = new HashSet<>(response.size());
            for (JsonObject guid: response) {
                guids.add(guid.asMap().get(GUID_FIELD).asString());
            }
        } catch (JsonException e) {
            failed(e);
        }
        callback.completed(guids);
    }
}
