package ru.yandex.passport.contact.callback.fetcher;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.passport.contact.ContactContext;

public abstract class AbstractSequentialFetcher
        extends AbstractFilterFutureCallback<String, JsonObject>
{
    protected static final String BASE_QUERY = "/search?";
    private static final long FAILOVER_DELAY = 100;
    private static final boolean LOCALITY_SHUFFLE = true;

    private ContactContext context;

    protected AbstractSequentialFetcher(ContactContext context, FutureCallback<? super JsonObject> callback) {
        super(callback);
        this.context = context;
    }

    @Override
    public void completed(String response) {
        try {
            context = withUserContext(context, response);
            String query = buildQuery(context);
            context.session().logger().info("Sequential request " + query);
            context.proxy().sequentialRequest(
                    context.session(),
                    context,
                    new BasicAsyncRequestProducerGenerator(query),
                    failoverDelay(),
                    localityShuffle(),
                    JsonAsyncTypesafeDomConsumerFactory.OK,
                    context.session().listener().createContextGeneratorFor(context.client()),
                    callback
            );
        } catch (BadRequestException e) {
            failed(e);
        }
    }

    protected long failoverDelay() {
        return FAILOVER_DELAY;
    }

    protected boolean localityShuffle() {
        return LOCALITY_SHUFFLE;
    }

    protected String buildQuery(ContactContext context) throws BadRequestException {
        QueryConstructor query = new QueryConstructor(BASE_QUERY);
        query.append("service", service());
        query.append("get", get());
        return buildQuery(query, context) + "&text=" + text(context);
    }

    protected abstract String buildQuery(
        QueryConstructor query,
        ContactContext context) throws BadRequestException;

    // Returns name of the service for the request
    protected abstract String service();

    // Returns get fields for the request, separated by comma
    protected abstract String get();

    // Returns text field for the request
    protected abstract String text(ContactContext context);

    // Returns context with User with given id and service
    protected abstract ContactContext withUserContext(ContactContext context, String id);
}
