package ru.yandex.passport.contact.callback.fetcher;

import java.util.Collection;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.passport.contact.ContactContext;
import ru.yandex.passport.contact.callback.extractor.ContactExtractor;
import ru.yandex.passport.contact.utils.Contact;

public class ContactsByGuidFetcher extends AbstractSequentialFetcher {
    private static final String CONTACT_USER_ID_FIELD = "contact_user_id";
    private static final int IO_PRIO = 0;
    private static final String JSON_TYPE = "dollar";
    private static final int LENGTH = 400;
    private static final String RECENT_CONTACTS = "true";

    public ContactsByGuidFetcher(
            ContactContext context,
            FutureCallback<? super Collection<Contact>> callback)
    {
        super(context, new ContactExtractor(callback));
    }

    protected ContactsByGuidFetcher(FutureCallback<? super JsonObject> callback, ContactContext context) {
        super(context, callback);
    }

    @Override
    protected String buildQuery(QueryConstructor query, ContactContext context) throws BadRequestException {
        query.append("recent_contacts", RECENT_CONTACTS);

        query.append("IO_PRIO", IO_PRIO);
        query.append("json_type", JSON_TYPE);
        query.append("length", LENGTH);
        query.append("prefix", context.user().prefix().toString());
        return query.toString();
    }

    @Override
    protected String service() {
        return "messenger_messages";
    }

    @Override
    protected String get() {
        return "contact_id,contact_name,contact_user_id";
    }

    @Override
    protected ContactContext withUserContext(ContactContext context, String response) {
        return context.inMessagesService(response);
    }
    @Override
    protected String text(ContactContext context) {
        return CONTACT_USER_ID_FIELD + ":" + context.user().prefix();
    }
}
