package ru.yandex.passport.contact.callback.fetcher;

import java.util.Collection;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.passport.contact.ContactContext;
import ru.yandex.passport.contact.callback.extractor.GuidExtractor;

/*
This class is used to load list of guids for a given puid from the backend.
 */
public class GuidsByPuidFetcher extends AbstractSequentialFetcher {
    private static final int PREFIX = 0; // prefix is constant in this request

    public GuidsByPuidFetcher(
            ContactContext context,
            FutureCallback<? super Collection<String>> callback)
    {
        super(context, new GuidExtractor(callback));
    }

    @Override
    protected String buildQuery(
            QueryConstructor query,
            ContactContext context)
    {
        query.append("prefix", PREFIX);
        return query.toString();
    }

    @Override
    protected String service() {
        return "messenger_users";
    }

    @Override
    protected String get() {
        return "user_id";
    }

    @Override
    protected ContactContext withUserContext(ContactContext context, String response) {
        return context.inUsersService(response);
    }

    @Override
    protected String text(ContactContext context) {
        return "type_p:user+AND+user_uid:" + context.user().prefix();
    }
}
