package ru.yandex.passport.contact.callback.fetcher;


import org.apache.http.concurrent.FutureCallback;

import ru.yandex.passport.contact.ContactContext;
import ru.yandex.passport.contact.callback.extractor.NonEmptyExtractor;

/*
 This class fetches a contact with a given contact_id (targetGuid stored in Context) for a given user's guid.
 */
public class HasContactInContactsFetcher extends ContactsByGuidFetcher {
    private static final String CONTACT_ID_FIELD = "contact_id";
    public HasContactInContactsFetcher(ContactContext context, FutureCallback<Boolean> callback) {
        super(new NonEmptyExtractor(callback), context);
    }

    @Override
    protected String text(ContactContext context) {
        return super.text(context) + "+AND+" + CONTACT_ID_FIELD + ':' + context.targetGuid();
    }
}
