package ru.yandex.passport.contact.callback.utils;

import java.util.Collection;
import java.util.stream.Collectors;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;

public class FlatCallback<T>
    extends AbstractFilterFutureCallback<Collection<Collection<T>>, Collection<T>> {
    public FlatCallback(FutureCallback<? super Collection<T>> callback) {
        super(callback);
    }
    @Override
    public void completed(Collection<Collection<T>> collections) {
        callback.completed(collections.stream().flatMap(Collection::stream).collect(Collectors.toList()));
    }
}
