package ru.yandex.passport.contact.callback.utils;

import com.google.common.cache.Cache;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.passport.contact.ContactContext;

public class PutToCacheCallback<U, T> extends AbstractFilterFutureCallback<T, T> {
    private final U key;
    private final Cache<U, T> cache;
    private final ContactContext context;

    public PutToCacheCallback(
        ContactContext context,
        U key,
        Cache<U, T> cache,
        FutureCallback<? super T> callback)
    {
        super(callback);
        this.context = context;
        this.key = key;
        this.cache = cache;
    }

    @Override
    public void completed(T response) {
        context.session().logger().info("Data cached");
        cache.put(key, response);
        callback.completed(response);
    }
}
