package ru.yandex.passport.contact.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class ContactProxyConfigBuilder
        extends AbstractContactProxyConfigBuilder<ContactProxyConfigBuilder> {
    public ContactProxyConfigBuilder() {
        this(ContactProxyConfigDefaults.INSTANCE);
    }

    public ContactProxyConfigBuilder(final ContactProxyConfig config) {
        super(config);
    }

    public ContactProxyConfigBuilder(
            final IniConfig config)
            throws ConfigException {
        this(config, ContactProxyConfigDefaults.INSTANCE);
    }

    public ContactProxyConfigBuilder(
            final IniConfig config,
            final ContactProxyConfig defaults)
            throws ConfigException {
        super(config, defaults);
    }

    public ImmutableContactProxyConfig build() throws ConfigException {
        return new ImmutableContactProxyConfig(
                this);
    }

    @Override
    public ContactProxyConfigBuilder self() {
        return this;
    }
}
