package ru.yandex.passport.contact.utils;

import java.util.Objects;

public class Contact {
    private final String guid;
    private final String contactName;
    private final String ownerId;

    public Contact(String guid, String contactName, String ownerId) {
        this.guid = guid;
        this.contactName = contactName;
        this.ownerId = ownerId;
    }

    public String guid() {
        return guid;
    }

    public String contactName() {
        return contactName;
    }

    public String ownerId() {
        return ownerId;
    }

    @Override
    public int hashCode() {
        return guid.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Contact)) {
            return false;
        }
        Contact other = (Contact) o;
        return Objects.equals(guid, other.guid);
    }

    @Override
    public String toString() {
        return String.format("Contact {guid: %s, name: %s, owner_guid: %s}", guid, contactName, ownerId);
    }
}
