#!/bin/bash
set -exo pipefail
source recommended_java_args.sh
source classpath.sh
source documents_proxy.gc.args.sh
source documents_proxy_config.sh

export TVM_API_HOST=https://tvm-api.yandex.net

export LJINX_WORKERS=2
export DOCUMENTS_APP_PORT=81
export DOCUMENTS_APP_DEBUG_PORT=82

MEM_ARGS="-Xms${XMS} -Xmx${XMX}  -Xmn384M -Xmaxf0.4 -Xminf0.2 -Xmine256M -Xmaxe1G -Xmint0.03"
GC_ARGS="-XX:ActiveProcessorCount=${CPU_CORES} -Xgcpolicy:balanced -verbose:gc -Xverbosegclog:/logs/gc#.log,10,10000"
DUMP_ARGS="-Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"

#    -cp $CLASSPATH ru.yandex.multistarter.MultiStarter \
#    ru.yandex.ljinx.Ljinx documents_proxy_ljinx.conf ";" \

exec $BSCONFIG_IDIR/jdk/bin/java \
    $MEM_ARGS $DUMP_ARGS $GC_ARGS $NET_ARGS \
    -Djava.library.path=documents_proxy -DQUEUE_NAME=$QUEUE_NAME \
    -cp $CLASSPATH ru.yandex.multistarter.MultiStarter \
	  ru.yandex.passport.DocumentsProxy documents_proxy.conf ";" \
    ru.yandex.msearch.Daemon -config documents_backend.conf ";" \
    ru.yandex.dispatcher.producer.Producer documents_producer.conf ";" \
    ru.yandex.dispatcher.consumer.ConsumerServer -config documents_consumer.conf
    #-cp $CLASSPATH ru.yandex.ljinx.Ljinx documents_proxy_ljinx.confл
